/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.dvc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.basepom.mojo.dvc.QualifiedName;

public final class QualifiedNameMatcher {
    private static final Pattern WILDCARD_REGEXP = Pattern.compile("[^*]+|(\\*)");
    private static final Pattern WILDCARD_MATCH = Pattern.compile(".*");
    private final Pattern groupPattern;
    private final Pattern artifactPattern;

    public static QualifiedNameMatcher fromQualifiedName(QualifiedName name) {
        Preconditions.checkNotNull((Object)name, (Object)"name is null");
        return new QualifiedNameMatcher(name.getMinimalName());
    }

    public QualifiedNameMatcher(String pattern) {
        Preconditions.checkNotNull((Object)pattern, (Object)"pattern is null");
        List elements = Splitter.on((char)':').trimResults().splitToList((CharSequence)pattern);
        Preconditions.checkState((elements.size() > 0 && elements.size() < 3 ? 1 : 0) != 0, (String)"Pattern %s is not a valid inclusion pattern!", (Object)pattern);
        this.groupPattern = QualifiedNameMatcher.compileWildcard(((String)elements.get(0)).trim());
        this.artifactPattern = QualifiedNameMatcher.compileWildcard(elements.size() > 1 ? ((String)elements.get(1)).trim() : "");
    }

    public boolean matches(QualifiedName artifactName) {
        Preconditions.checkNotNull((Object)artifactName, (Object)"artifactName is null");
        return this.groupPattern.matcher(artifactName.getGroupId()).matches() && this.artifactPattern.matcher(artifactName.getArtifactId()).matches();
    }

    @VisibleForTesting
    static Pattern compileWildcard(String wildcard) {
        if (wildcard.isEmpty()) {
            return WILDCARD_MATCH;
        }
        Matcher m = WILDCARD_REGEXP.matcher(wildcard);
        StringBuffer b = new StringBuffer();
        while (m.find()) {
            if (m.group(1) != null) {
                m.appendReplacement(b, ".*");
                continue;
            }
            m.appendReplacement(b, "\\\\Q" + m.group(0) + "\\\\E");
        }
        m.appendTail(b);
        return Pattern.compile(b.toString());
    }
}

