/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.dvc;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;

public final class ScopeLimitingFilter
implements DependencyFilter {
    public static final String COMPILE_PLUS_RUNTIME = "compile+runtime";
    public static final String RUNTIME_PLUS_SYSTEM = "runtime+system";
    private final ImmutableSet<Scope> scopes;

    public static ScopeLimitingFilter computeDependencyScope(String scope) {
        return new ScopeLimitingFilter(ScopeLimitingFilter.computeScopes(scope));
    }

    public static ScopeLimitingFilter computeTransitiveScope(String scope) {
        return new ScopeLimitingFilter(ScopeLimitingFilter.computeScopes(ScopeLimitingFilter.computeTransitiveScopes(scope)));
    }

    private ScopeLimitingFilter(Set<Scope> scopes) {
        this.scopes = ImmutableSet.copyOf(scopes);
    }

    private static EnumSet<Scope> computeScopes(String scope) {
        Preconditions.checkNotNull((Object)scope, (Object)"scope is null");
        switch (scope) {
            case "compile": {
                return EnumSet.of(Scope.compile, Scope.system, Scope.provided);
            }
            case "runtime": {
                return EnumSet.of(Scope.compile, Scope.runtime);
            }
            case "compile+runtime": {
                return EnumSet.of(Scope.compile, Scope.system, Scope.provided, Scope.runtime);
            }
            case "runtime+system": {
                return EnumSet.of(Scope.compile, Scope.system, Scope.runtime);
            }
            case "test": {
                return EnumSet.allOf(Scope.class);
            }
        }
        throw new IllegalStateException("Scope '" + scope + "' is unknown!");
    }

    private static String computeTransitiveScopes(String scope) {
        Preconditions.checkNotNull((Object)scope, (Object)"scope is null");
        switch (scope) {
            case "compile": 
            case "runtime": 
            case "compile+runtime": 
            case "runtime+system": {
                return scope;
            }
            case "test": {
                return COMPILE_PLUS_RUNTIME;
            }
            case "provided": {
                return COMPILE_PLUS_RUNTIME;
            }
        }
        throw new IllegalStateException("Scope '" + scope + "' is unknown!");
    }

    public boolean accept(DependencyNode node, List<DependencyNode> parents) {
        String scope;
        Preconditions.checkNotNull((Object)node, (Object)"node is null");
        if (node.getDependency() == null) {
            return true;
        }
        switch (scope = node.getDependency().getScope()) {
            case "compile": {
                return this.scopes.contains((Object)Scope.compile);
            }
            case "test": {
                return this.scopes.contains((Object)Scope.test);
            }
            case "runtime": {
                return this.scopes.contains((Object)Scope.runtime);
            }
            case "provided": {
                return this.scopes.contains((Object)Scope.provided);
            }
            case "system": {
                return this.scopes.contains((Object)Scope.system);
            }
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("scopes", this.scopes).toString();
    }

    static enum Scope {
        compile,
        runtime,
        test,
        provided,
        system;

    }
}

