/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.dvc.mojo;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.Map;
import java.util.NavigableSet;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.shared.utils.logging.MessageBuilder;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.basepom.mojo.dvc.AbstractDependencyVersionsMojo;
import org.basepom.mojo.dvc.QualifiedName;
import org.basepom.mojo.dvc.dependency.DependencyMap;
import org.basepom.mojo.dvc.version.VersionResolutionCollection;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.version.Version;

@Mojo(name="list", requiresProject=true, threadSafe=true, requiresDependencyResolution=ResolutionScope.NONE, defaultPhase=LifecyclePhase.VERIFY)
public final class DependencyVersionsListMojo
extends AbstractDependencyVersionsMojo {
    @Parameter(defaultValue="false", property="dvc.conflicts-only")
    public boolean conflictsOnly = false;

    @Override
    protected void doExecute(ImmutableSetMultimap<QualifiedName, VersionResolutionCollection> resolutionMap, DependencyMap rootDependencyMap) {
        ImmutableMap filteredMap = ImmutableMap.copyOf((Map)Maps.filterValues((Map)resolutionMap.asMap(), v -> {
            boolean report = true;
            if (this.conflictsOnly) {
                report &= v.stream().anyMatch(VersionResolutionCollection::hasConflict);
            }
            if (this.directOnly) {
                report &= v.stream().anyMatch(VersionResolutionCollection::hasDirectDependencies);
            }
            if (this.managedOnly) {
                report &= v.stream().anyMatch(VersionResolutionCollection::hasManagedDependencies);
            }
            return report;
        }));
        this.LOG.report(this.quiet, "%s%s dependencies%s for '%s' scope%s:", this.directOnly ? "Direct" : "All", this.managedOnly ? " managed" : "", this.deepScan ? " using deep scan" : "", this.scope, this.conflictsOnly ? ", reporting only conflicts" : "");
        if (filteredMap.isEmpty()) {
            return;
        }
        ImmutableMap<QualifiedName, DependencyNode> rootDependencies = rootDependencyMap.getAllDependencies();
        int namePadding = filteredMap.keySet().stream().map(QualifiedName::length).reduce(0, Math::max);
        int scopePadding = rootDependencies.entrySet().stream().filter(e -> filteredMap.containsKey(e.getKey())).map(e -> ((DependencyNode)e.getValue()).getDependency().getScope().length()).reduce(0, Math::max);
        for (Map.Entry entry : filteredMap.entrySet()) {
            boolean isManaged;
            QualifiedName dependencyName = (QualifiedName)entry.getKey();
            DependencyNode currentDependency = (DependencyNode)rootDependencies.get((Object)dependencyName);
            assert (currentDependency != null);
            ImmutableSortedSet resolutions = ImmutableSortedSet.copyOf((Collection)((Collection)entry.getValue()));
            MessageBuilder mb = MessageUtils.buffer();
            mb.a((CharSequence)Strings.padEnd((String)(dependencyName.getShortName() + ": "), (int)(namePadding + 2), (char)' ')).a((CharSequence)Strings.padEnd((String)currentDependency.getDependency().getScope(), (int)(scopePadding + 1), (char)' '));
            Version dependencyVersion = currentDependency.getVersion();
            Preconditions.checkState((dependencyVersion != null ? 1 : 0) != 0, (String)"Dependency Version for %s is null! File a bug!", (Object)currentDependency);
            ComparableVersion actualVersion = new ComparableVersion(dependencyVersion.toString());
            boolean isDirect = resolutions.stream().anyMatch(VersionResolutionCollection::hasDirectDependencies);
            boolean bl = isManaged = (currentDependency.getManagedBits() & 1) != 0;
            if (isManaged) {
                mb.warning((Object)actualVersion);
            } else if (isDirect) {
                mb.strong((Object)actualVersion);
            } else {
                mb.a((Object)actualVersion);
            }
            ImmutableSortedSet unselectedVersions = ImmutableSortedSet.copyOf((Collection)Sets.filter((NavigableSet)resolutions, v -> !v.isMatchFor(actualVersion)));
            if (!unselectedVersions.isEmpty()) {
                mb.a((CharSequence)" (");
                UnmodifiableIterator it = unselectedVersions.iterator();
                while (it.hasNext()) {
                    VersionResolutionCollection resolution = (VersionResolutionCollection)it.next();
                    String result = resolution.getExpectedVersion().toString();
                    if (resolution.hasConflict()) {
                        mb.failure((Object)("!" + result + "!"));
                    } else if (resolution.isMatchFor(actualVersion)) {
                        mb.success((Object)result);
                    } else if (resolution.hasDirectDependencies()) {
                        mb.strong((Object)("*" + result + "*"));
                    } else {
                        mb.a((CharSequence)result);
                    }
                    if (!it.hasNext()) continue;
                    mb.a((CharSequence)", ");
                }
                mb.a((CharSequence)")");
            }
            this.LOG.info("%s", mb);
        }
    }
}

