/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.dvc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Objects;
import java.util.Optional;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;

public final class QualifiedName
implements Comparable<QualifiedName> {
    private final String groupId;
    private final String artifactId;
    private final String type;
    private final String classifier;

    public static QualifiedName fromDependencyNode(DependencyNode dependencyNode) {
        Preconditions.checkNotNull((Object)dependencyNode, (Object)"dependency is null");
        return QualifiedName.fromArtifact(RepositoryUtils.toArtifact((Artifact)dependencyNode.getArtifact()));
    }

    public static QualifiedName fromDependency(Dependency dependency) {
        Preconditions.checkNotNull((Object)dependency, (Object)"dependency is null");
        return QualifiedName.fromArtifact(RepositoryUtils.toArtifact((Artifact)dependency.getArtifact()));
    }

    public static QualifiedName fromArtifact(org.apache.maven.artifact.Artifact artifact) {
        Preconditions.checkNotNull((Object)artifact, (Object)"artifact is null");
        return new QualifiedName(artifact.getGroupId(), artifact.getArtifactId(), artifact.getType(), artifact.getClassifier());
    }

    public static QualifiedName fromProject(MavenProject project) {
        Preconditions.checkNotNull((Object)project, (Object)"project is null");
        return new QualifiedName(project.getGroupId(), project.getArtifactId(), null, null);
    }

    @VisibleForTesting
    QualifiedName(String groupId, String artifactId, String type, String classifier) {
        this.groupId = (String)Preconditions.checkNotNull((Object)groupId, (Object)"groupId is null");
        this.artifactId = (String)Preconditions.checkNotNull((Object)artifactId, (Object)"artifactId is null");
        this.type = type;
        this.classifier = classifier;
        Preconditions.checkState((classifier == null || type != null ? 1 : 0) != 0, (Object)"Classifier must be null if type is null");
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public Optional<String> getType() {
        return Optional.ofNullable(this.type);
    }

    public Optional<String> getClassifier() {
        return Optional.ofNullable(this.classifier);
    }

    public boolean hasTests() {
        return this.getType().map(t -> t.equals("test-jar")).orElse(false) != false || this.getClassifier().map(c -> c.equals("tests")).orElse(false) != false && this.getType().map(t -> t.equals("jar")).orElse(false) != false;
    }

    public String getFullName() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)this.getGroupId()).add((Object)this.getArtifactId());
        this.getType().ifPresent(t -> builder.add(t));
        this.getClassifier().ifPresent(t -> builder.add(t));
        return Joiner.on((char)':').join((Iterable)builder.build());
    }

    public String getShortName() {
        String classifier;
        Object result = Joiner.on((char)':').skipNulls().join((Object)this.getGroupId(), (Object)this.getArtifactId(), new Object[0]);
        String string = classifier = this.hasTests() ? "tests" : this.getClassifier().orElse("");
        if (!classifier.isEmpty()) {
            result = (String)result + " (" + classifier + ")";
        }
        return result;
    }

    public int length() {
        return this.getShortName().length();
    }

    public String getMinimalName() {
        return Joiner.on((char)':').join((Object)this.getGroupId(), (Object)this.getArtifactId(), new Object[0]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QualifiedName that = (QualifiedName)o;
        if (Objects.equals(this.groupId, that.groupId) && Objects.equals(this.artifactId, that.artifactId)) {
            if (this.hasTests() && ((QualifiedName)o).hasTests()) {
                return true;
            }
            return Objects.equals(this.getType().orElse("jar"), that.getType().orElse("jar")) && Objects.equals(this.getClassifier().orElse(""), that.getClassifier().orElse(""));
        }
        return false;
    }

    public int hashCode() {
        if (this.hasTests()) {
            return Objects.hash(this.groupId, this.artifactId, "test-jar", "tests");
        }
        return Objects.hash(this.groupId, this.artifactId, this.getType().orElse("jar"), this.getClassifier().orElse(""));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("groupId", (Object)this.groupId).add("artifactId", (Object)this.artifactId).add("type", (Object)this.type).add("classifier", (Object)this.classifier).toString();
    }

    @Override
    public int compareTo(QualifiedName other) {
        if (other == null) {
            return 1;
        }
        if (other == this || this.equals(other)) {
            return 0;
        }
        return this.getMinimalName().compareTo(other.getMinimalName());
    }
}

