/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.dvc;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.basepom.mojo.dvc.QualifiedName;
import org.basepom.mojo.dvc.QualifiedNameMatcher;
import org.basepom.mojo.dvc.model.ResolverDefinition;
import org.basepom.mojo.dvc.strategy.Strategy;
import org.basepom.mojo.dvc.strategy.StrategyProvider;

public final class StrategyCache {
    private final Cache<QualifiedName, Strategy> resolverCache = CacheBuilder.newBuilder().concurrencyLevel(10).build();
    private final ImmutableMap<QualifiedNameMatcher, Strategy> resolverPatterns;
    private final Strategy defaultStrategy;

    StrategyCache(StrategyProvider strategyProvider, ResolverDefinition[] resolvers, String defaultStrategyName) {
        Preconditions.checkNotNull((Object)strategyProvider, (Object)"strategyProvider is null");
        Preconditions.checkNotNull((Object)resolvers, (Object)"resolvers is null");
        Preconditions.checkNotNull((Object)defaultStrategyName, (Object)"defaultStrategyName is null");
        this.defaultStrategy = strategyProvider.forName(defaultStrategyName);
        Preconditions.checkState((this.defaultStrategy != null ? 1 : 0) != 0, (String)"Could not locate default version strategy '%s'", (Object)defaultStrategyName);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Arrays.stream(resolvers).forEach(r -> {
            Strategy strategy = strategyProvider.forName(r.getStrategy());
            Preconditions.checkState((strategy != null ? 1 : 0) != 0, (String)"Could not locate version strategy %s! Check for typos!", (Object)r.getStrategy());
            r.getIncludes().forEach(include -> builder.put(include, (Object)strategy));
        });
        this.resolverPatterns = builder.build();
    }

    public Strategy forQualifiedName(QualifiedName name) {
        Preconditions.checkNotNull((Object)name, (Object)"name is null");
        try {
            return (Strategy)this.resolverCache.get((Object)name, () -> {
                for (Map.Entry entry : this.resolverPatterns.entrySet()) {
                    if (!((QualifiedNameMatcher)entry.getKey()).matches(name)) continue;
                    return (Strategy)entry.getValue();
                }
                return this.defaultStrategy;
            });
        }
        catch (ExecutionException e) {
            return this.defaultStrategy;
        }
    }
}

