/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.dvc.dependency;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.project.DefaultDependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingResult;
import org.basepom.mojo.dvc.Context;
import org.basepom.mojo.dvc.PluginLog;
import org.basepom.mojo.dvc.QualifiedName;
import org.basepom.mojo.dvc.dependency.DependencyMap;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.transfer.ArtifactTransferException;
import org.eclipse.aether.transfer.NoRepositoryLayoutException;

public final class DependencyMapBuilder {
    private static final PluginLog LOG = new PluginLog(DependencyMapBuilder.class);
    private final Context context;

    public DependencyMapBuilder(Context context) {
        this.context = (Context)Preconditions.checkNotNull((Object)context, (Object)"context is null");
    }

    public DependencyMap mapDependency(DependencyNode dependencyNode, DependencyFilter projectScopeFilter) throws DependencyResolutionException, ProjectBuildingException {
        Preconditions.checkNotNull((Object)dependencyNode, (Object)"dependencyNode is null");
        Preconditions.checkNotNull((Object)projectScopeFilter, (Object)"projectScopeFilter is null");
        ProjectBuildingResult result = this.context.getProjectBuilder().build(DependencyMapBuilder.convertFromAetherDependency(dependencyNode), false, this.context.createProjectBuildingRequest());
        MavenProject project = result.getProject();
        return this.mapProject(project, projectScopeFilter);
    }

    public DependencyMap mapProject(MavenProject project, DependencyFilter scopeFilter) throws DependencyResolutionException {
        DependencyResolutionResult result;
        block8: {
            Preconditions.checkNotNull((Object)project, (Object)"project is null");
            Preconditions.checkNotNull((Object)scopeFilter, (Object)"scopeFilter is null");
            DefaultDependencyResolutionRequest request = new DefaultDependencyResolutionRequest();
            request.setRepositorySession(this.context.getRepositorySystemSession());
            request.setMavenProject(project);
            request.setResolutionFilter(scopeFilter);
            try {
                result = this.context.getProjectDependenciesResolver().resolve((DependencyResolutionRequest)request);
            }
            catch (DependencyResolutionException e) {
                result = e.getResult();
                ImmutableSet reactorProjects = (ImmutableSet)this.context.getReactorProjects().stream().map(ProjectKey::fromProject).collect(ImmutableSet.toImmutableSet());
                ImmutableSet reactorDependencies = (ImmutableSet)result.getUnresolvedDependencies().stream().filter(d -> reactorProjects.contains((Object)ProjectKey.fromDependency(d))).collect(ImmutableSet.toImmutableSet());
                result.getUnresolvedDependencies().removeAll((Collection<?>)reactorDependencies);
                result.getResolvedDependencies().addAll(reactorDependencies);
                if (!this.context.isUnresolvedSystemArtifactsFailBuild()) {
                    ImmutableSet systemDependencies = (ImmutableSet)result.getUnresolvedDependencies().stream().filter(d -> "system".equals(d.getScope())).collect(ImmutableSet.toImmutableSet());
                    result.getUnresolvedDependencies().removeAll((Collection<?>)systemDependencies);
                    result.getResolvedDependencies().addAll(systemDependencies);
                }
                if (!this.context.isOptionalDependenciesMustExist()) {
                    ImmutableSet optionalDependencies = (ImmutableSet)result.getUnresolvedDependencies().stream().filter(Dependency::isOptional).collect(ImmutableSet.toImmutableSet());
                    result.getUnresolvedDependencies().removeAll((Collection<?>)optionalDependencies);
                    result.getResolvedDependencies().addAll(optionalDependencies);
                }
                if (result.getUnresolvedDependencies().isEmpty()) break block8;
                Throwable t = Throwables.getRootCause((Throwable)e);
                RemoteRepository repository = null;
                if (t instanceof NoRepositoryLayoutException) {
                    repository = ((NoRepositoryLayoutException)t).getRepository();
                } else if (t instanceof ArtifactTransferException) {
                    repository = ((ArtifactTransferException)t).getRepository();
                }
                if (repository != null && "legacy".equals(repository.getContentType())) {
                    LOG.warn("Could not access a legacy repository for artifacts:  %s; Reason: %s", result.getUnresolvedDependencies(), t.getMessage());
                }
                throw e;
            }
        }
        DependencyNode graph = result.getDependencyGraph();
        ImmutableMap.Builder dependencyCollector = ImmutableMap.builder();
        ImmutableMap<QualifiedName, DependencyNode> directDependencies = this.loadDependencyTree(graph, scopeFilter, (ImmutableMap.Builder<QualifiedName, DependencyNode>)dependencyCollector);
        dependencyCollector.putAll(directDependencies);
        return new DependencyMap((ImmutableMap<QualifiedName, DependencyNode>)dependencyCollector.build(), directDependencies);
    }

    private ImmutableMap<QualifiedName, DependencyNode> loadDependencyTree(DependencyNode node, DependencyFilter filter, ImmutableMap.Builder<QualifiedName, DependencyNode> allDependencyCollector) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (DependencyNode dependencyNode : node.getChildren()) {
            if (dependencyNode.getManagedBits() != 0) {
                if ((dependencyNode.getManagedBits() & 1) != 0) {
                    LOG.debug("%s -> Managed Version!", dependencyNode.getArtifact());
                }
                if ((dependencyNode.getManagedBits() & 2) != 0) {
                    LOG.debug("%s -> Managed Scope!", dependencyNode.getArtifact());
                }
                if ((dependencyNode.getManagedBits() & 4) != 0) {
                    LOG.debug("%s -> Managed Optional!", dependencyNode.getArtifact());
                }
                if ((dependencyNode.getManagedBits() & 8) != 0) {
                    LOG.debug("%s -> Managed Properties!", dependencyNode.getArtifact());
                }
                if ((dependencyNode.getManagedBits() & 0x10) != 0) {
                    LOG.debug("%s -> Managed Exclusions!", dependencyNode.getArtifact());
                }
            }
            if (!filter.accept(dependencyNode, (List)ImmutableList.of((Object)node))) continue;
            QualifiedName name = QualifiedName.fromDependencyNode(dependencyNode);
            builder.put((Object)name, (Object)dependencyNode);
            allDependencyCollector.putAll(this.loadDependencyTree(dependencyNode, filter, allDependencyCollector));
        }
        return builder.build();
    }

    static org.apache.maven.artifact.Artifact convertFromAetherDependency(DependencyNode dependencyNode) {
        Artifact aetherArtifact = DependencyMapBuilder.convertToPomArtifact(dependencyNode.getArtifact());
        org.apache.maven.artifact.Artifact mavenArtifact = RepositoryUtils.toArtifact((Artifact)aetherArtifact);
        mavenArtifact.setScope(dependencyNode.getDependency().getScope());
        mavenArtifact.setOptional(dependencyNode.getDependency().isOptional());
        return mavenArtifact;
    }

    static Artifact convertToPomArtifact(Artifact artifact) {
        if (artifact.getClassifier().isEmpty() && "pom".equals(artifact.getExtension())) {
            return artifact;
        }
        return new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), "pom", artifact.getVersion());
    }

    private static final class ProjectKey {
        private final String groupId;
        private final String artifactId;
        private final String version;

        public static ProjectKey fromProject(MavenProject project) {
            Preconditions.checkNotNull((Object)project, (Object)"project; is null");
            return new ProjectKey(project.getGroupId(), project.getArtifactId(), project.getVersion());
        }

        public static ProjectKey fromDependency(Dependency dependency) {
            Preconditions.checkNotNull((Object)dependency, (Object)"artifact; is null");
            return new ProjectKey(dependency.getArtifact().getGroupId(), dependency.getArtifact().getArtifactId(), dependency.getArtifact().getVersion());
        }

        private ProjectKey(String groupId, String artifactId, String version) {
            this.groupId = (String)Preconditions.checkNotNull((Object)groupId, (Object)"groupId is null");
            this.artifactId = (String)Preconditions.checkNotNull((Object)artifactId, (Object)"artifactId is null");
            this.version = (String)Preconditions.checkNotNull((Object)version, (Object)"version is null");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProjectKey that = (ProjectKey)o;
            return this.groupId.equals(that.groupId) && this.artifactId.equals(that.artifactId) && this.version.equals(that.version);
        }

        public int hashCode() {
            return Objects.hash(this.groupId, this.artifactId, this.version);
        }
    }
}

