/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.dvc.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.basepom.mojo.dvc.QualifiedName;
import org.basepom.mojo.dvc.QualifiedNameMatcher;
import org.eclipse.aether.graph.DependencyNode;

public class VersionCheckExcludes {
    private String dependency = "";
    private ComparableVersion expected;
    private ComparableVersion resolved;

    public void setDependency(String dependency) {
        this.dependency = ((String)Preconditions.checkNotNull((Object)dependency, (Object)"dependency is null")).trim();
    }

    public void setExpected(String version) {
        Preconditions.checkNotNull((Object)version, (Object)"version is null");
        this.expected = new ComparableVersion(version);
    }

    public void setResolved(String version) {
        Preconditions.checkNotNull((Object)version, (Object)"version is null");
        this.resolved = new ComparableVersion(version);
    }

    public boolean isValid() {
        return this.expected != null && this.resolved != null;
    }

    public boolean matches(DependencyNode dependencyNode, ComparableVersion expectedVersion, ComparableVersion resolvedVersion) {
        Preconditions.checkNotNull((Object)dependencyNode, (Object)"dependencyNode is null");
        Preconditions.checkNotNull((Object)expectedVersion, (Object)"expectedVersion is null");
        Preconditions.checkNotNull((Object)resolvedVersion, (Object)"resolvedVersion is null");
        QualifiedNameMatcher matcher = new QualifiedNameMatcher(this.dependency);
        QualifiedName artifactName = QualifiedName.fromDependencyNode(dependencyNode);
        return matcher.matches(artifactName) && this.expected.equals((Object)expectedVersion) && this.resolved.equals((Object)resolvedVersion);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("dependency", (Object)this.dependency).add("expected", (Object)this.expected).add("resolved", (Object)this.resolved).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionCheckExcludes that = (VersionCheckExcludes)o;
        return Objects.equals(this.dependency, that.dependency) && Objects.equals(this.expected, that.expected) && Objects.equals(this.resolved, that.resolved);
    }

    public int hashCode() {
        return Objects.hash(this.dependency, this.expected, this.resolved);
    }
}

