/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.dvc.mojo;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.shared.utils.logging.MessageBuilder;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.basepom.mojo.dvc.AbstractDependencyVersionsMojo;
import org.basepom.mojo.dvc.QualifiedName;
import org.basepom.mojo.dvc.dependency.DependencyMap;
import org.basepom.mojo.dvc.strategy.Strategy;
import org.basepom.mojo.dvc.version.VersionResolutionCollection;
import org.basepom.mojo.dvc.version.VersionResolutionElement;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.version.Version;

@Mojo(name="check", requiresProject=true, threadSafe=true, defaultPhase=LifecyclePhase.VERIFY, requiresDependencyResolution=ResolutionScope.NONE)
public class DependencyVersionsCheckMojo
extends AbstractDependencyVersionsMojo {
    @Parameter(defaultValue="true", property="dvc.conflicts-only")
    public boolean conflictsOnly = true;
    @Parameter(defaultValue="false", alias="failBuildInCaseOfConflict", property="dvc.conflicts-fail-build")
    protected boolean conflictsFailBuild = false;
    @Parameter(defaultValue="false", property="dvc.direct-conflicts-fail-build")
    protected boolean directConflictsFailBuild = false;

    @Override
    protected void doExecute(ImmutableSetMultimap<QualifiedName, VersionResolutionCollection> resolutionMap, DependencyMap rootDependencyMap) throws Exception {
        ImmutableMap filteredMap = ImmutableMap.copyOf((Map)Maps.filterValues((Map)resolutionMap.asMap(), v -> {
            boolean report = true;
            if (this.conflictsOnly) {
                report &= v.stream().anyMatch(VersionResolutionCollection::hasConflict);
            }
            if (this.directOnly) {
                report &= v.stream().anyMatch(VersionResolutionCollection::hasDirectDependencies);
            }
            if (this.managedOnly) {
                report &= v.stream().anyMatch(VersionResolutionCollection::hasManagedDependencies);
            }
            return report;
        }));
        this.log.report(this.quiet, "Checking %s%s dependencies%s for '%s' scope%s", this.directOnly ? "direct" : "all", this.managedOnly ? ", managed" : "", this.deepScan ? " using deep scan" : "", this.scope, this.conflictsOnly ? ", reporting only conflicts" : "");
        if (filteredMap.isEmpty()) {
            return;
        }
        ImmutableMap<QualifiedName, DependencyNode> rootDependencies = rootDependencyMap.getAllDependencies();
        boolean directConflicts = false;
        boolean transitiveConflicts = false;
        for (Map.Entry entry : filteredMap.entrySet()) {
            ImmutableSetMultimap versionMap = (ImmutableSetMultimap)((Collection)entry.getValue()).stream().collect(ImmutableSetMultimap.toImmutableSetMultimap(VersionResolutionCollection::getExpectedVersion, Function.identity()));
            boolean willWarn = false;
            boolean willFail = false;
            boolean isDirect = ((Collection)entry.getValue()).stream().anyMatch(VersionResolutionCollection::hasDirectDependencies);
            QualifiedName dependencyName = (QualifiedName)entry.getKey();
            DependencyNode currentDependency = (DependencyNode)rootDependencies.get((Object)dependencyName);
            assert (currentDependency != null);
            boolean isManaged = (currentDependency.getManagedBits() & 1) != 0;
            Version dependencyVersion = currentDependency.getVersion();
            Preconditions.checkState((dependencyVersion != null ? 1 : 0) != 0, (String)"Dependency Version for %s is null! File a bug!", (Object)currentDependency);
            ComparableVersion resolvedVersion = new ComparableVersion(dependencyVersion.toString());
            Strategy strategy = this.strategyCache.forQualifiedName(dependencyName);
            MessageBuilder mb = MessageUtils.buffer();
            mb.strong((Object)dependencyName.getShortName()).a((CharSequence)": ").strong((Object)resolvedVersion).format(" (%s%s) - scope: %s - strategy: %s", new Object[]{isDirect ? "direct" : "transitive", isManaged ? ", managed" : "", currentDependency.getDependency().getScope(), strategy.getName()}).newline();
            int versionPadding = versionMap.keySet().stream().map(v -> v.toString().length()).reduce(0, Math::max);
            for (Map.Entry versionEntry : versionMap.asMap().entrySet()) {
                boolean hasConflictVersion = ((Collection)versionEntry.getValue()).stream().anyMatch(VersionResolutionCollection::hasConflict);
                boolean perfectMatch = ((Collection)versionEntry.getValue()).stream().anyMatch(v -> v.isMatchFor(resolvedVersion));
                String paddedVersion = Strings.padEnd((String)((ComparableVersion)versionEntry.getKey()).toString(), (int)(versionPadding + 1), (char)' ');
                mb.a((CharSequence)"       ");
                if (hasConflictVersion) {
                    mb.failure((Object)paddedVersion);
                } else if (perfectMatch) {
                    mb.success((Object)paddedVersion);
                } else {
                    mb.a((CharSequence)paddedVersion);
                }
                mb.a((CharSequence)"expected by ");
                Iterator it = ((Collection)versionEntry.getValue()).stream().flatMap(v -> v.getRequestingDependencies().stream()).iterator();
                while (it.hasNext()) {
                    VersionResolutionElement versionResolutionElement = (VersionResolutionElement)it.next();
                    String name = versionResolutionElement.getRequestingDependency().getShortName();
                    if (versionResolutionElement.isDirectDependency()) {
                        mb.strong((Object)("*" + name + "*"));
                    } else {
                        mb.a((CharSequence)name);
                    }
                    if (!it.hasNext()) continue;
                    mb.a((CharSequence)", ");
                }
                mb.newline();
                if (!hasConflictVersion) continue;
                willWarn = true;
                willFail |= this.conflictsFailBuild;
                willFail |= isDirect && this.directConflictsFailBuild;
                directConflicts |= isDirect;
                transitiveConflicts |= !isDirect;
            }
            if (willFail) {
                this.log.error("%s", mb);
                continue;
            }
            if (willWarn) {
                this.log.warn("%s", mb);
                continue;
            }
            this.log.info("%s", mb);
        }
        if (directConflicts && (this.conflictsFailBuild || this.directConflictsFailBuild)) {
            throw new MojoFailureException("Version conflict in direct dependencies detected!");
        }
        if (transitiveConflicts && this.conflictsFailBuild) {
            throw new MojoFailureException("Version conflict in transitive dependencies detected!");
        }
    }
}

