/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.dvc.strategy;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Comparator;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.basepom.mojo.dvc.strategy.Strategy;

@Named(value="apr")
@Singleton
public class AprVersionStrategy
implements Strategy {
    private final Comparator<ArtifactVersion> comparator = Comparator.comparing(ArtifactVersion::getMajorVersion, this::checkMajorCompatible).thenComparing(ArtifactVersion::getMinorVersion, this::checkMinorCompatible).thenComparing(ArtifactVersion::getIncrementalVersion, this::checkPatchCompatible).thenComparing(ArtifactVersion::getQualifier, (a, e) -> this.checkQualifierCompatible(Strings.nullToEmpty((String)a), Strings.nullToEmpty((String)e)));

    @Override
    public String getName() {
        return "apr";
    }

    @Override
    public final boolean isCompatible(ComparableVersion expectedVersion, ComparableVersion resolvedVersion) {
        DefaultArtifactVersion aprResolvedVersion;
        DefaultArtifactVersion aprExpectedVersion = new DefaultArtifactVersion(((ComparableVersion)Preconditions.checkNotNull((Object)expectedVersion, (Object)"expectedVersion is null")).getCanonical());
        return this.comparator.compare((ArtifactVersion)aprExpectedVersion, (ArtifactVersion)(aprResolvedVersion = new DefaultArtifactVersion(((ComparableVersion)Preconditions.checkNotNull((Object)resolvedVersion, (Object)"resolvedVersion is null")).getCanonical()))) >= 0;
    }

    protected int checkMajorCompatible(int expectedMajor, int resolvedMajor) {
        if (expectedMajor != resolvedMajor) {
            return -1;
        }
        return 0;
    }

    protected int checkMinorCompatible(int expectedMinor, int resolvedMinor) {
        if (resolvedMinor < expectedMinor) {
            return -1;
        }
        return 0;
    }

    protected int checkPatchCompatible(int expectedPatch, int resolvedPatch) {
        return 0;
    }

    protected int checkQualifierCompatible(String expectedQualifier, String resolvedQualifier) {
        if (!expectedQualifier.equals(resolvedQualifier)) {
            return -1;
        }
        return 0;
    }
}

