/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.dvc.version;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.basepom.mojo.dvc.QualifiedName;
import org.basepom.mojo.dvc.version.VersionResolutionElement;

public final class VersionResolution {
    private final VersionResolutionElement requestingDependency;
    private final ComparableVersion expectedVersion;

    public static VersionResolution forDirectDependency(QualifiedName requestingDependency, ComparableVersion expectedVersion, boolean managedDependency) {
        return new VersionResolution(requestingDependency, expectedVersion, managedDependency, true);
    }

    public static VersionResolution forTransitiveDependency(QualifiedName requestingDependency, ComparableVersion expectedVersion, boolean managedDependency) {
        return new VersionResolution(requestingDependency, expectedVersion, managedDependency, false);
    }

    private VersionResolution(QualifiedName requestingDependency, ComparableVersion expectedVersion, boolean manageDependency, boolean directDependency) {
        Preconditions.checkNotNull((Object)requestingDependency, (Object)"requestingDependencyName is null");
        this.requestingDependency = new VersionResolutionElement(requestingDependency, manageDependency, directDependency);
        this.expectedVersion = (ComparableVersion)Preconditions.checkNotNull((Object)expectedVersion, (Object)"expectedVersion is null");
    }

    public VersionResolutionElement getRequestingDependency() {
        return this.requestingDependency;
    }

    public ComparableVersion getExpectedVersion() {
        return this.expectedVersion;
    }

    public void conflict() {
        this.requestingDependency.conflict();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionResolution that = (VersionResolution)o;
        return this.requestingDependency.equals(that.requestingDependency) && this.expectedVersion.equals((Object)that.expectedVersion);
    }

    public int hashCode() {
        return Objects.hash(this.requestingDependency, this.expectedVersion);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("requestingDependency", (Object)this.requestingDependency).add("expectedVersion", (Object)this.expectedVersion).toString();
    }
}

