/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.dvc.version;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.basepom.mojo.dvc.QualifiedName;
import org.basepom.mojo.dvc.version.VersionResolution;
import org.basepom.mojo.dvc.version.VersionResolutionElement;

public final class VersionResolutionCollection
implements Comparable<VersionResolutionCollection> {
    private final ImmutableSortedSet<VersionResolutionElement> requestingDependencies;
    private final ComparableVersion expectedVersion;

    private VersionResolutionCollection(Map.Entry<ComparableVersion, Collection<VersionResolutionElement>> entry) {
        Preconditions.checkNotNull(entry, (Object)"entry is null");
        this.expectedVersion = entry.getKey();
        this.requestingDependencies = ImmutableSortedSet.copyOf(entry.getValue());
    }

    public ImmutableSortedSet<VersionResolutionElement> getRequestingDependencies() {
        return this.requestingDependencies;
    }

    public ComparableVersion getExpectedVersion() {
        return this.expectedVersion;
    }

    public boolean isMatchFor(ComparableVersion version) {
        Preconditions.checkNotNull((Object)version, (Object)"version is null");
        return this.expectedVersion.getCanonical().equals(version.getCanonical());
    }

    @Override
    public int compareTo(VersionResolutionCollection other) {
        if (other == null) {
            return 1;
        }
        if (other == this || this.equals(other)) {
            return 0;
        }
        return this.getExpectedVersion().compareTo(other.getExpectedVersion());
    }

    public boolean hasConflict() {
        return this.requestingDependencies.stream().anyMatch(VersionResolutionElement::hasConflict);
    }

    public boolean hasDirectDependencies() {
        return this.requestingDependencies.stream().anyMatch(VersionResolutionElement::isDirectDependency);
    }

    public boolean hasManagedDependencies() {
        return this.requestingDependencies.stream().anyMatch(VersionResolutionElement::isManagedDependency);
    }

    public static ImmutableSetMultimap<QualifiedName, VersionResolutionCollection> toResolutionMap(SetMultimap<QualifiedName, VersionResolution> map) {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        builder.orderKeysBy(QualifiedName::compareTo).orderValuesBy(VersionResolutionCollection::compareTo);
        Maps.transformValues((Map)map.asMap(), v -> {
            ImmutableSetMultimap versionMap = (ImmutableSetMultimap)v.stream().collect(ImmutableSetMultimap.toImmutableSetMultimap(VersionResolution::getExpectedVersion, VersionResolution::getRequestingDependency));
            return (ImmutableSet)versionMap.asMap().entrySet().stream().map(VersionResolutionCollection::new).collect(ImmutableSet.toImmutableSet());
        }).forEach((arg_0, arg_1) -> ((ImmutableSetMultimap.Builder)builder).putAll(arg_0, arg_1));
        return builder.build();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("requestingDependencies", this.requestingDependencies).add("expectedVersion", (Object)this.expectedVersion).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionResolutionCollection that = (VersionResolutionCollection)o;
        return this.requestingDependencies.equals(that.requestingDependencies) && this.expectedVersion.equals((Object)that.expectedVersion);
    }

    public int hashCode() {
        return Objects.hash(this.requestingDependencies, this.expectedVersion);
    }
}

