/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.duplicatefinder;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multimaps;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.SortedSet;
import java.util.stream.Collectors;
import org.basepom.mojo.duplicatefinder.ClasspathElement;
import org.basepom.mojo.duplicatefinder.ConflictState;
import org.basepom.mojo.duplicatefinder.ConflictType;

@SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
public class ResultCollector {
    private final EnumSet<ConflictState> printState;
    private final EnumSet<ConflictState> failState;
    private final EnumMap<ConflictType, EnumSet<ConflictState>> seenResults = new EnumMap(ConflictType.class);
    private final ListMultimap<String, ConflictResult> results = MultimapBuilder.SetMultimapBuilder.linkedHashKeys().arrayListValues().build();
    private ConflictState conflictState = ConflictState.NO_CONFLICT;

    ResultCollector(EnumSet<ConflictState> printState, EnumSet<ConflictState> failState) {
        this.printState = printState;
        this.failState = failState;
        for (ConflictType conflictType : ConflictType.values()) {
            this.seenResults.put(conflictType, EnumSet.noneOf(ConflictState.class));
        }
    }

    public ConflictState getConflictState() {
        return this.conflictState;
    }

    public boolean isFailed() {
        return this.failState.contains((Object)this.conflictState);
    }

    public boolean hasConflictsFor(ConflictType type, ConflictState state) {
        return this.seenResults.get((Object)type).contains((Object)state);
    }

    public void addConflict(ConflictType type, String name, SortedSet<ClasspathElement> conflictingClasspathElements, boolean excepted, ConflictState state) {
        if (!excepted) {
            this.conflictState = ConflictState.max(this.conflictState, state);
            this.seenResults.get((Object)type).add(state);
        }
        ConflictResult conflictResult = new ConflictResult(type, name, conflictingClasspathElements, excepted, state);
        this.results.put((Object)conflictResult.getConflictName(), (Object)conflictResult);
    }

    public Map<String, Collection<ConflictResult>> getResults(ConflictType type, ConflictState state) {
        Multimap result = Multimaps.filterValues(this.results, conflictResult -> {
            Preconditions.checkNotNull((Object)conflictResult, (Object)"conflictResult is null");
            return conflictResult.getConflictState() == state && conflictResult.getType() == type && !conflictResult.isExcepted();
        });
        return ImmutableMap.copyOf((Map)result.asMap());
    }

    Map<String, Collection<ConflictResult>> getAllResults() {
        return ImmutableMap.copyOf((Map)this.results.asMap());
    }

    private static String buildConflictName(SortedSet<ClasspathElement> conflictArtifactNames) {
        return Joiner.on((String)", ").join((Iterable)conflictArtifactNames.stream().map(ClasspathElement.getNameFunction()).collect(Collectors.toList()));
    }

    public class ConflictResult {
        private final ConflictType type;
        private final String name;
        private final SortedSet<ClasspathElement> classpathElements;
        private final boolean excepted;
        private final ConflictState conflictState;
        private final String conflictName;

        ConflictResult(ConflictType type, String name, SortedSet<ClasspathElement> classpathElements, boolean excepted, ConflictState conflictState) {
            this.type = type;
            this.name = name;
            this.classpathElements = classpathElements;
            this.excepted = excepted;
            this.conflictState = conflictState;
            this.conflictName = ResultCollector.buildConflictName(classpathElements);
        }

        public String getName() {
            return this.name;
        }

        public ConflictType getType() {
            return this.type;
        }

        public SortedSet<ClasspathElement> getClasspathElements() {
            return this.classpathElements;
        }

        public boolean isExcepted() {
            return this.excepted;
        }

        public boolean isPrinted() {
            return !this.excepted && ResultCollector.this.printState.contains((Object)this.conflictState);
        }

        public boolean isFailed() {
            return !this.excepted && ResultCollector.this.failState.contains((Object)this.conflictState);
        }

        public ConflictState getConflictState() {
            return this.conflictState;
        }

        private String getConflictName() {
            return this.conflictName;
        }
    }
}

