/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.duplicatefinder.classpath;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MatchPatternPredicate
implements Predicate<String> {
    private static final Logger LOG = LoggerFactory.getLogger(MatchPatternPredicate.class);
    private final ImmutableList<Pattern> patterns;

    MatchPatternPredicate(Collection<String> patternStrings) {
        Preconditions.checkNotNull(patternStrings, (Object)"patternStrings is null");
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String patternString : patternStrings) {
            builder.add((Object)Pattern.compile(patternString, 66));
        }
        this.patterns = builder.build();
    }

    public ImmutableList<Pattern> getPatterns() {
        return this.patterns;
    }

    public boolean apply(String input) {
        if (input != null) {
            for (Pattern pattern : this.patterns) {
                if (!pattern.matcher(input).matches()) continue;
                LOG.debug(String.format("Ignoring '%s' (matches %s)", input, pattern.pattern()));
                return true;
            }
        }
        return false;
    }
}

