/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.inline.mojo;

import com.google.common.base.Preconditions;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.maven.shared.utils.logging.MessageBuilder;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PluginLog {
    private final Logger logger;
    private final Lock instanceLock = new ReentrantLock();

    PluginLog(Class<?> clazz) {
        Preconditions.checkNotNull(clazz, (Object)"clazz is null");
        this.logger = LoggerFactory.getLogger(clazz);
    }

    public void debug(String fmt, Object ... args) {
        Preconditions.checkNotNull((Object)fmt, (Object)"fmt is null");
        try {
            this.instanceLock.lock();
            this.logger.debug(String.format(fmt, args));
        }
        finally {
            this.instanceLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debug(Throwable t, String fmt, Object ... args) {
        Preconditions.checkNotNull((Object)fmt, (Object)"fmt is null");
        Preconditions.checkNotNull((Object)t, (Object)"t is null");
        try {
            this.instanceLock.lock();
            this.logger.debug(String.format(fmt, args), t);
        }
        finally {
            this.instanceLock.unlock();
        }
    }

    public void info(String fmt, Object ... args) {
        Preconditions.checkNotNull((Object)fmt, (Object)"fmt is null");
        try {
            this.instanceLock.lock();
            this.logger.info(String.format(fmt, args));
        }
        finally {
            this.instanceLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void info(Throwable t, String fmt, Object ... args) {
        Preconditions.checkNotNull((Object)fmt, (Object)"fmt is null");
        Preconditions.checkNotNull((Object)t, (Object)"t is null");
        try {
            this.instanceLock.lock();
            this.logger.info(String.format(fmt, args), t);
        }
        finally {
            this.instanceLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warn(String fmt, Object ... args) {
        Preconditions.checkNotNull((Object)fmt, (Object)"fmt is null");
        MessageBuilder mb = MessageUtils.buffer();
        try {
            this.instanceLock.lock();
            this.logger.warn(mb.warning((Object)String.format(fmt, args)).build());
        }
        finally {
            this.instanceLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warn(Throwable t, String fmt, Object ... args) {
        Preconditions.checkNotNull((Object)fmt, (Object)"fmt is null");
        Preconditions.checkNotNull((Object)t, (Object)"t is null");
        MessageBuilder mb = MessageUtils.buffer();
        try {
            this.instanceLock.lock();
            this.logger.warn(mb.warning((Object)String.format(fmt, args)).build(), t);
        }
        finally {
            this.instanceLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(String fmt, Object ... args) {
        Preconditions.checkNotNull((Object)fmt, (Object)"fmt is null");
        MessageBuilder mb = MessageUtils.buffer();
        try {
            this.instanceLock.lock();
            this.logger.error(mb.failure((Object)String.format(fmt, args)).build());
        }
        finally {
            this.instanceLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(Throwable t, String fmt, Object ... args) {
        Preconditions.checkNotNull((Object)fmt, (Object)"fmt is null");
        Preconditions.checkNotNull((Object)t, (Object)"t is null");
        MessageBuilder mb = MessageUtils.buffer();
        try {
            this.instanceLock.lock();
            this.logger.error(mb.failure((Object)String.format(fmt, args)).build(), t);
        }
        finally {
            this.instanceLock.unlock();
        }
    }

    public void report(boolean quiet, String fmt, Object ... args) {
        if (quiet) {
            this.debug(fmt, args);
        } else {
            this.info(fmt, args);
        }
    }
}

