/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.inline.mojo;

import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.io.CharStreams;
import com.google.common.io.Closer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.basepom.inline.mojo.ArtifactIdentifier;
import org.basepom.inline.mojo.DependencyBuilder;
import org.basepom.inline.mojo.InlineDependency;
import org.basepom.inline.mojo.PluginLog;
import org.basepom.inline.mojo.PomUtil;
import org.basepom.inline.mojo.ScopeLimitingFilter;
import org.basepom.inline.mojo.TreeNode;
import org.basepom.inline.transformer.ClassPath;
import org.basepom.inline.transformer.ClassPathResource;
import org.basepom.inline.transformer.ClassPathTag;
import org.basepom.inline.transformer.JarTransformer;
import org.basepom.inline.transformer.TransformerException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.graph.Dependency;
import org.jdom2.JDOMException;

@Mojo(name="inline", defaultPhase=LifecyclePhase.PACKAGE, requiresProject=true, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public final class InlineMojo
extends AbstractMojo {
    private static final PluginLog LOG = new PluginLog(InlineMojo.class);
    private static final Predicate<Dependency> EXCLUDE_SYSTEM_SCOPE = dependency -> !"system".equals(dependency.getScope());
    private static final Predicate<Dependency> EXCLUDE_PROVIDED_SCOPE = dependency -> !"provided".equals(dependency.getScope());
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession mavenSession;
    @Parameter(defaultValue="${reactorProjects}", readonly=true, required=true)
    private List<MavenProject> reactorProjects;
    @Component
    private ProjectBuilder mavenProjectBuilder;
    @Component
    private ProjectDependenciesResolver projectDependenciesResolver;
    @Component
    private RepositorySystem repositorySystem;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(defaultValue="${project.build.directory}")
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.outputTimestamp}")
    private String outputTimestamp;
    @Parameter(property="inline.pomFile", defaultValue="${project.file}")
    private File pomFile;
    @Parameter
    private List<InlineDependency> inlineDependencies = ImmutableList.of();
    @Parameter
    private List<ArtifactIdentifier> includes = ImmutableList.of();
    @Parameter
    private List<ArtifactIdentifier> excludes = ImmutableList.of();
    @Parameter
    private List<String> additionalProcessors = ImmutableList.of();
    @Parameter(defaultValue="true", property="inline.hide-classes")
    private boolean hideClasses;
    @Parameter(defaultValue="false", property="inline.skip")
    private boolean skip;
    @Parameter(defaultValue="false", property="inline.quiet")
    private boolean quiet;
    @Parameter(required=true, property="inline.prefix")
    private String prefix;
    @Parameter(defaultValue="true", property="inline.failOnNoMatch")
    private boolean failOnNoMatch;
    @Parameter(defaultValue="true", property="inline.failOnDuplicate")
    private boolean failOnDuplicate;
    @Parameter
    private File outputJarFile;
    @Parameter
    private File outputPomFile;
    @Parameter(defaultValue="false", property="inline.attachArtifact")
    private boolean inlinedArtifactAttached;
    @Parameter(defaultValue="true", property="inline.replacePomFile")
    private boolean replacePomFile;
    @Parameter(defaultValue="inlined")
    private String inlinedClassifierName;
    private final Closer closer = Closer.create();

    public void setInlineDependencies(List<InlineDependency> inlineDependencies) {
        this.inlineDependencies = ImmutableList.copyOf(inlineDependencies);
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes.stream().map(ArtifactIdentifier::new).collect(Collectors.toList());
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes.stream().map(ArtifactIdentifier::new).collect(Collectors.toList());
    }

    public void setAdditionalProcessors(List<String> processors) {
        this.additionalProcessors = ImmutableList.copyOf(processors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        if (this.skip) {
            LOG.report(this.quiet, "skipping plugin execution", new Object[0]);
            return;
        }
        if ("pom".equals(this.project.getPackaging())) {
            LOG.report(this.quiet, "ignoring POM project", new Object[0]);
            return;
        }
        if (this.project.getArtifact().getFile() == null) {
            throw new MojoExecutionException("No project artifact found!");
        }
        Instant timestamp = MavenArchiver.parseBuildOutputTimestamp((String)this.outputTimestamp).orElseGet(Instant::now);
        try {
            ImmutableSetMultimap.Builder dependencyBuilder = ImmutableSetMultimap.builder();
            ImmutableSet.Builder pomDependenciesToAdd = ImmutableSet.builder();
            try {
                this.computeDependencyMap((ImmutableSetMultimap.Builder<InlineDependency, Dependency>)dependencyBuilder, (ImmutableSet.Builder<Dependency>)pomDependenciesToAdd);
                ImmutableSetMultimap dependencyMap = dependencyBuilder.build();
                this.rewriteJarFile(timestamp.toEpochMilli(), (ImmutableSetMultimap<InlineDependency, Dependency>)dependencyMap);
                this.rewritePomFile((Set<Dependency>)pomDependenciesToAdd.build(), (Set<Dependency>)ImmutableSet.copyOf((Collection)dependencyMap.values()));
            }
            finally {
                this.closer.close();
            }
        }
        catch (UncheckedIOException e) {
            throw new MojoExecutionException((Throwable)e.getCause());
        }
        catch (IOException | XMLStreamException | DependencyResolutionException | ProjectBuildingException | TransformerException | JDOMException e) {
            throw new MojoExecutionException(e);
        }
    }

    private void computeDependencyMap(ImmutableSetMultimap.Builder<InlineDependency, Dependency> dependencyMapBuilder, ImmutableSet.Builder<Dependency> pomBuilder) throws DependencyResolutionException, ProjectBuildingException {
        DependencyBuilder dependencyBuilder = new DependencyBuilder(this.project, this.mavenSession, this.mavenProjectBuilder, this.projectDependenciesResolver, this.reactorProjects);
        ImmutableSet directArtifacts = (ImmutableSet)this.project.getDependencyArtifacts().stream().map(ArtifactIdentifier::new).collect(ImmutableSet.toImmutableSet());
        ImmutableList<Dependency> directDependencies = dependencyBuilder.mapProject(this.project, (node, parents) -> directArtifacts.contains((Object)new ArtifactIdentifier(node)));
        ImmutableList<Dependency> projectDependencies = dependencyBuilder.mapProject(this.project, ScopeLimitingFilter.computeDependencyScope("compile+runtime"));
        Map idMap = (Map)projectDependencies.stream().filter(dependency -> dependency.getArtifact() != null).collect(ImmutableMap.toImmutableMap(InlineMojo::getId, (Function)Functions.identity()));
        BiConsumer<InlineDependency, Dependency> dependencyConsumer = (inlineDependency, dependency) -> {
            LOG.debug("%s matches %s for inlining.", inlineDependency, dependency);
            dependencyMapBuilder.put(inlineDependency, dependency);
        };
        ImmutableSet.Builder directExcludes = ImmutableSet.builder();
        ImmutableSortedSet.Builder directLogBuilder = ImmutableSortedSet.naturalOrder();
        directDependencies.stream().filter(this.createFilterSet(true)).forEach(dependency -> {
            Optional<InlineDependency> inlineDependency = this.findInlineDependencyMatch((Dependency)dependency);
            if (inlineDependency.isPresent()) {
                dependencyConsumer.accept(inlineDependency.get(), (Dependency)dependency);
                directLogBuilder.add((Object)dependency.toString());
            } else {
                directExcludes.add(dependency);
            }
        });
        ImmutableSortedSet directLog = directLogBuilder.build();
        if (!this.quiet) {
            LOG.info("Inlined dependencies", new Object[0]);
            LOG.info("====================", new Object[0]);
            for (String dependency2 : directLog) {
                LOG.info("    %s", dependency2);
            }
            LOG.info("", new Object[0]);
        }
        Set excludes = directExcludes.build().stream().map(ArtifactIdentifier::new).collect(Collectors.toUnmodifiableSet());
        this.excludes = ImmutableList.copyOf((Iterable)Iterables.concat(this.excludes, excludes));
        LOG.debug("Excludes after creating includes: %s", this.excludes);
        ImmutableMap directDependencyMap = dependencyMapBuilder.build().asMap();
        ImmutableSortedSet.Builder transitiveLogBuilder = ImmutableSortedSet.naturalOrder();
        for (Map.Entry dependencyEntry : directDependencyMap.entrySet()) {
            InlineDependency inlineDependency2 = (InlineDependency)dependencyEntry.getKey();
            for (Dependency projectDependency : (Collection)dependencyEntry.getValue()) {
                Consumer<Dependency> consumer = inlineDependency2.isInlineTransitive() ? dependency -> {
                    Optional<InlineDependency> explicitMatch = this.findInlineDependencyMatch((Dependency)dependency);
                    if (!"runtime".equals(dependency.getScope()) || explicitMatch.isPresent()) {
                        dependencyConsumer.accept(inlineDependency2, (Dependency)dependency);
                        transitiveLogBuilder.add((Object)dependency.toString());
                    } else {
                        pomBuilder.add(dependency);
                    }
                } : arg_0 -> pomBuilder.add(arg_0);
                dependencyBuilder.mapDependency(projectDependency, ScopeLimitingFilter.computeTransitiveScope(projectDependency.getScope())).stream().map(dependency -> idMap.getOrDefault(InlineMojo.getId(dependency), dependency)).filter(this.createFilterSet(inlineDependency2.isInlineOptionals())).filter(this::isDependencyIncluded).forEach(consumer);
            }
        }
        if (!this.quiet) {
            LOG.info("", new Object[0]);
            LOG.info("Transitive dependencies", new Object[0]);
            LOG.info("=======================", new Object[0]);
            for (String dependency3 : Sets.difference((Set)transitiveLogBuilder.build(), (Set)directLog)) {
                LOG.info("    %s", dependency3);
            }
            LOG.info("", new Object[0]);
        }
    }

    private Optional<InlineDependency> findInlineDependencyMatch(Dependency dependency) {
        for (InlineDependency inlineDependency : this.inlineDependencies) {
            if (!inlineDependency.matchDependency(dependency)) continue;
            return Optional.of(inlineDependency);
        }
        return Optional.empty();
    }

    private static String getId(Dependency dependency) {
        org.eclipse.aether.artifact.Artifact artifact = dependency.getArtifact();
        Preconditions.checkState((artifact != null ? 1 : 0) != 0, (String)"Artifact for dependency %s is null!", (Object)dependency);
        return Joiner.on((char)':').join((Object)artifact.getGroupId(), (Object)artifact.getArtifactId(), new Object[]{artifact.getClassifier()});
    }

    private Predicate<Dependency> createFilterSet(boolean includeOptional) {
        Predicate<Dependency> predicate = EXCLUDE_SYSTEM_SCOPE;
        predicate = predicate.and(EXCLUDE_PROVIDED_SCOPE);
        if (!includeOptional) {
            predicate = predicate.and(Predicate.not(Dependency::isOptional));
        }
        return predicate;
    }

    public boolean isDependencyIncluded(Dependency dependency) {
        boolean included = this.includes.stream().map(artifactIdentifier -> artifactIdentifier.matchDependency(dependency)).findFirst().orElse(this.includes.isEmpty());
        boolean excluded = this.excludes.stream().map(artifactIdentifier -> artifactIdentifier.matchDependency(dependency)).findFirst().orElse(false);
        return included && !excluded;
    }

    private void rewriteJarFile(long timestamp, ImmutableSetMultimap<InlineDependency, Dependency> dependencies) throws TransformerException, IOException {
        File outputJar = this.outputJarFile != null ? this.outputJarFile : this.inlinedArtifactFileWithClassifier();
        TreeNode treeRoot = this.createJarContents(timestamp, dependencies);
        try (JarOutputStream jarOutputStream = new JarOutputStream(Files.newOutputStream(outputJar.toPath(), new OpenOption[0]));){
            Consumer<ClassPathResource> jarConsumer = this.getJarWriter(jarOutputStream);
            this.writeSubtree("META-INF/MANIFEST.MF", treeRoot, jarConsumer);
            this.writeSubtree("META-INF", treeRoot, jarConsumer);
            this.writeSubtree("", treeRoot, jarConsumer);
        }
        if (this.outputJarFile == null) {
            if (this.inlinedArtifactAttached) {
                LOG.info("Attaching inlined artifact.", new Object[0]);
                this.projectHelper.attachArtifact(this.project, this.project.getArtifact().getType(), this.inlinedClassifierName, outputJar);
            } else {
                LOG.info("Replacing original artifact with inlined artifact.", new Object[0]);
                File originalArtifact = this.project.getArtifact().getFile();
                if (originalArtifact != null) {
                    File backupFile = new File(originalArtifact.getParentFile(), "original-" + originalArtifact.getName());
                    Files.move(originalArtifact.toPath(), backupFile.toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
                    Files.move(outputJar.toPath(), originalArtifact.toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
                }
            }
        }
    }

    private void rewritePomFile(Set<Dependency> dependenciesToAdd, Set<Dependency> dependenciesToRemove) throws IOException, XMLStreamException, JDOMException {
        String pomContents;
        try (BufferedReader reader = Files.newBufferedReader(this.project.getFile().toPath(), StandardCharsets.UTF_8);){
            pomContents = CharStreams.toString((Readable)reader);
        }
        PomUtil pomUtil = new PomUtil(pomContents);
        dependenciesToRemove.forEach(pomUtil::removeDependency);
        dependenciesToAdd.forEach(pomUtil::addDependency);
        Object pomName = this.pomFile.getName();
        pomName = "new-" + (String)(((String)pomName).startsWith(".") ? ((String)pomName).substring(1) : pomName);
        File newPomFile = this.outputPomFile != null ? this.outputPomFile : new File(this.outputDirectory, (String)pomName);
        try (BufferedWriter writer = Files.newBufferedWriter(newPomFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            pomUtil.writePom(writer);
        }
        if (this.replacePomFile) {
            this.project.setPomFile(newPomFile);
        }
    }

    private TreeNode createJarContents(long timestamp, ImmutableSetMultimap<InlineDependency, Dependency> dependencies) throws TransformerException, IOException {
        TreeNode treeRoot = TreeNode.getRootNode();
        Consumer<ClassPathResource> jarConsumer = this.getJarBuilder(treeRoot);
        JarTransformer transformer = new JarTransformer(jarConsumer, timestamp, true, ImmutableSet.copyOf(this.additionalProcessors));
        ClassPath classPath = new ClassPath(this.project.getBasedir(), timestamp, this.closer);
        Artifact artifact = this.project.getArtifact();
        classPath.addFile(artifact.getFile(), artifact.getGroupId(), artifact.getArtifactId(), new ClassPathTag[]{ClassPathTag.ROOT_JAR});
        dependencies.forEach((inlineDependency, dependency) -> {
            org.eclipse.aether.artifact.Artifact dependencyArtifact = dependency.getArtifact();
            Preconditions.checkState((dependencyArtifact.getFile() != null ? 1 : 0) != 0, (String)"Could not locate artifact file for %s", (Object)dependencyArtifact);
            classPath.addFile(dependencyArtifact.getFile(), this.prefix, dependencyArtifact.getGroupId(), dependencyArtifact.getArtifactId(), this.hideClasses, new ClassPathTag[0]);
        });
        transformer.transform(classPath);
        return treeRoot;
    }

    private void writeSubtree(String name, TreeNode root, Consumer<ClassPathResource> jarWriter) {
        List elements = Splitter.on((char)'/').omitEmptyStrings().splitToList((CharSequence)name);
        TreeNode parent = root;
        for (String element : elements) {
            TreeNode child = parent.getChild(element);
            Preconditions.checkState((child != null ? 1 : 0) != 0, (String)"Could not find child '%s' for parent '%s' (%s)", (Object)element, (Object)parent.getName(), (Object)name);
            if (child.needsWriting()) {
                jarWriter.accept(child.getClassPathResource());
                child.write();
            }
            parent = child;
        }
        this.writeChildrenDepthFirst(parent, jarWriter);
    }

    private void writeChildrenDepthFirst(TreeNode writeNode, Consumer<ClassPathResource> jarWriter) {
        SortedMap<String, TreeNode> children;
        if (writeNode.needsWriting()) {
            jarWriter.accept(writeNode.getClassPathResource());
            writeNode.write();
        }
        if ((children = writeNode.getChildren()).isEmpty()) {
            return;
        }
        for (TreeNode childNode : children.values()) {
            this.writeChildrenDepthFirst(childNode, jarWriter);
        }
    }

    private Consumer<ClassPathResource> getJarWriter(JarOutputStream jarOutputStream) {
        return classPathResource -> {
            try {
                String name = classPathResource.getName();
                LOG.debug(String.format("Writing '%s' to jar", name), new Object[0]);
                JarEntry outputEntry = new JarEntry(name);
                outputEntry.setTime(classPathResource.getLastModifiedTime());
                outputEntry.setCompressedSize(-1L);
                jarOutputStream.putNextEntry(outputEntry);
                jarOutputStream.write(classPathResource.getContent());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    private Consumer<ClassPathResource> getJarBuilder(TreeNode root) {
        return classPathResource -> {
            String name = classPathResource.getName();
            LOG.debug(String.format("Adding '%s' to jar", name), new Object[0]);
            List elements = Splitter.on((char)'/').omitEmptyStrings().splitToList((CharSequence)name);
            TreeNode parent = root;
            for (int i = 0; i < elements.size() - 1; ++i) {
                TreeNode child = parent.getChild((String)elements.get(i));
                Preconditions.checkState((child != null ? 1 : 0) != 0, (String)"Could not locate child '%s' in parent element '%s', this is a transformer problem!", elements.get(i), (Object)parent);
                parent = child;
            }
            parent.addChild((String)elements.get(elements.size() - 1), (ClassPathResource)classPathResource);
        };
    }

    private File inlinedArtifactFileWithClassifier() {
        Artifact artifact = this.project.getArtifact();
        String inlineName = String.format("%s-%s-%s.%s", this.project.getArtifactId(), artifact.getVersion(), this.inlinedClassifierName, artifact.getArtifactHandler().getExtension());
        return new File(this.outputDirectory, inlineName);
    }
}

