/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.inline.mojo;

import com.google.common.base.Strings;
import java.util.SortedMap;
import java.util.StringJoiner;
import java.util.TreeMap;
import org.basepom.inline.transformer.ClassPathResource;

public final class TreeNode {
    private final String name;
    private final ClassPathResource classPathResource;
    private final SortedMap<String, TreeNode> children = new TreeMap<String, TreeNode>();
    private boolean written = false;

    public static TreeNode getRootNode() {
        TreeNode rootNode = new TreeNode("", null);
        rootNode.written = true;
        return rootNode;
    }

    public TreeNode(String name, ClassPathResource classPathResource) {
        this.name = name;
        this.classPathResource = classPathResource;
    }

    public void addChild(String childName, ClassPathResource classPathResource) {
        this.children.computeIfAbsent(childName, k -> new TreeNode(childName, classPathResource));
    }

    public TreeNode getChild(String childName) {
        return (TreeNode)this.children.get(childName);
    }

    public String getName() {
        return this.name;
    }

    public ClassPathResource getClassPathResource() {
        return this.classPathResource;
    }

    public SortedMap<String, TreeNode> getChildren() {
        return this.children;
    }

    public void write() {
        this.written = true;
    }

    public boolean needsWriting() {
        return !this.written;
    }

    public String toString() {
        return this.render(0);
    }

    private String render(int indent) {
        StringBuilder result = new StringBuilder(this.renderNoChildren(indent));
        String indentPadding = Strings.repeat((String)" ", (int)indent);
        result.append('\n').append(indentPadding).append("children:\n");
        for (TreeNode child : this.children.values()) {
            result.append(indentPadding);
            result.append(child.render(indent + 2));
            result.append('\n');
        }
        return result.toString();
    }

    private String renderNoChildren(int indent) {
        StringJoiner result = new StringJoiner(", ", TreeNode.class.getSimpleName() + "[", "]").add("name='" + this.name + "'").add("written=" + this.written).add("classPathResource=" + String.valueOf(this.classPathResource));
        return Strings.repeat((String)" ", (int)indent) + String.valueOf(result);
    }
}

