/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.propertyhelper;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.inject.Inject;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.basepom.mojo.propertyhelper.DateField;
import org.basepom.mojo.propertyhelper.MacroField;
import org.basepom.mojo.propertyhelper.NumberField;
import org.basepom.mojo.propertyhelper.PropertyElement;
import org.basepom.mojo.propertyhelper.PropertyField;
import org.basepom.mojo.propertyhelper.StringField;
import org.basepom.mojo.propertyhelper.UuidField;
import org.basepom.mojo.propertyhelper.ValueCache;
import org.basepom.mojo.propertyhelper.beans.DateDefinition;
import org.basepom.mojo.propertyhelper.beans.IgnoreWarnFail;
import org.basepom.mojo.propertyhelper.beans.MacroDefinition;
import org.basepom.mojo.propertyhelper.beans.NumberDefinition;
import org.basepom.mojo.propertyhelper.beans.PropertyGroup;
import org.basepom.mojo.propertyhelper.beans.StringDefinition;
import org.basepom.mojo.propertyhelper.beans.UuidDefinition;
import org.basepom.mojo.propertyhelper.macros.MacroType;
import org.basepom.mojo.propertyhelper.util.Log;

public abstract class AbstractPropertyHelperMojo
extends AbstractMojo {
    protected static final Log LOG = Log.findLog();
    protected final ValueCache valueCache = new ValueCache();
    private final Map<String, String> values = Maps.newHashMap();
    @Parameter(defaultValue="fail")
    public String onDuplicateProperty = "fail";
    @Parameter(defaultValue="fail")
    public String onMissingProperty = "fail";
    @Parameter
    public String[] activeGroups = new String[0];
    @Parameter
    public PropertyGroup[] propertyGroups = new PropertyGroup[0];
    @Parameter
    public NumberDefinition[] numbers = new NumberDefinition[0];
    @Parameter
    public StringDefinition[] strings = new StringDefinition[0];
    @Parameter
    public DateDefinition[] dates = new DateDefinition[0];
    @Parameter
    public MacroDefinition[] macros = new MacroDefinition[0];
    @Parameter
    public UuidDefinition[] uuids = new UuidDefinition[0];
    @Parameter(defaultValue="${project}", readonly=true)
    public MavenProject project;
    @Parameter(defaultValue="${settings}", readonly=true)
    public Settings settings;
    @Parameter(required=true, readonly=true, defaultValue="${project.basedir}")
    public File basedir;
    @Parameter(defaultValue="false")
    boolean skip;
    public List<NumberField> numberFields = null;
    @Inject
    public Map<String, MacroType> macroMap = null;
    private boolean isSnapshot;

    public void execute() throws MojoExecutionException {
        block5: {
            this.isSnapshot = this.project.getArtifact().isSnapshot();
            LOG.debug("Project is a %s.", this.isSnapshot ? "snapshot" : "release");
            LOG.trace("%s on duplicate, %s on missing", this.onDuplicateProperty, this.onMissingProperty);
            try {
                if (this.skip) {
                    LOG.debug("Skipping execution!");
                    break block5;
                }
                this.doExecute();
            }
            catch (IOException e) {
                try {
                    throw new MojoExecutionException("While running mojo: ", (Exception)e);
                }
                catch (Throwable throwable) {
                    LOG.debug("Ended %s mojo run!", ((Object)((Object)this)).getClass().getSimpleName());
                    throw throwable;
                }
            }
        }
        LOG.debug("Ended %s mojo run!", ((Object)((Object)this)).getClass().getSimpleName());
    }

    public MavenProject getProject() {
        Preconditions.checkNotNull((Object)this.project, (Object)"project is null");
        return this.project;
    }

    public Settings getSettings() {
        Preconditions.checkNotNull((Object)this.settings, (Object)"settings is null");
        return this.settings;
    }

    public File getBasedir() {
        Preconditions.checkNotNull((Object)this.basedir, (Object)"basedir is null");
        return this.basedir;
    }

    public Map<String, MacroType> getMacros() {
        Preconditions.checkNotNull(this.macroMap, (Object)"macroMap is null");
        return this.macroMap;
    }

    @CheckForNull
    public List<NumberField> getNumbers() {
        return this.numberFields;
    }

    protected abstract void doExecute() throws IOException, MojoExecutionException;

    protected void loadPropertyElements() throws MojoExecutionException, IOException {
        ImmutableList.Builder propertyElements = ImmutableList.builder();
        this.numberFields = NumberField.createNumbers(this.valueCache, this.numbers);
        propertyElements.addAll(this.numberFields);
        propertyElements.addAll(StringField.createStrings(this.valueCache, this.strings));
        propertyElements.addAll(DateField.createDates(this.valueCache, this.dates));
        propertyElements.addAll(MacroField.createMacros(this.valueCache, this.macros, this));
        propertyElements.addAll(UuidField.createUuids(this.valueCache, this.uuids));
        for (PropertyElement pe : propertyElements.build()) {
            PropertyGroup[] value = pe.getPropertyValue();
            this.values.put(pe.getPropertyName(), value.orElse(null));
            if (pe.isExport()) {
                String result = value.orElse("");
                this.project.getProperties().setProperty(pe.getPropertyName(), result);
                LOG.debug("Exporting Property name: %s, value: %s", pe.getPropertyName(), result);
                continue;
            }
            LOG.debug("Property name: %s, value: %s", pe.getPropertyName(), value.orElse("<null>"));
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        HashSet propertyNames = Sets.newHashSet();
        if (this.propertyGroups != null) {
            for (PropertyGroup propertyGroup : this.propertyGroups) {
                List<PropertyElement> propertyFields = PropertyField.createProperties(this.project.getModel(), this.values, propertyGroup);
                builder.put((Object)propertyGroup.getId(), new AbstractMap.SimpleImmutableEntry<PropertyGroup, List<PropertyElement>>(propertyGroup, propertyFields));
            }
        }
        ImmutableMap propertyPairs = builder.build();
        if (this.activeGroups != null) {
            for (String activeGroup : this.activeGroups) {
                Map.Entry propertyElement = (Map.Entry)propertyPairs.get(activeGroup);
                Preconditions.checkState((propertyElement != null ? 1 : 0) != 0, (String)"activated group '%s' does not exist", (Object)activeGroup);
                PropertyGroup propertyGroup = (PropertyGroup)propertyElement.getKey();
                if (propertyGroup.isActiveOnRelease() && !this.isSnapshot || propertyGroup.isActiveOnSnapshot() && this.isSnapshot) {
                    for (PropertyElement pe : (List)propertyElement.getValue()) {
                        Optional<String> value = pe.getPropertyValue();
                        String propertyName = pe.getPropertyName();
                        IgnoreWarnFail.checkState(propertyGroup.getOnDuplicateProperty(), !propertyNames.contains(propertyName), "property name '" + propertyName + "'");
                        propertyNames.add(propertyName);
                        this.project.getProperties().setProperty(propertyName, value.orElse(""));
                    }
                    continue;
                }
                LOG.debug("Skipping property group %s: Snapshot: %b, activeOnSnapshot: %b, activeOnRelease: %b", activeGroup, this.isSnapshot, propertyGroup.isActiveOnSnapshot(), propertyGroup.isActiveOnRelease());
            }
        }
    }
}

