/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.propertyhelper;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.basepom.mojo.propertyhelper.PropertyElement;
import org.basepom.mojo.propertyhelper.ValueCache;
import org.basepom.mojo.propertyhelper.ValueProvider;
import org.basepom.mojo.propertyhelper.beans.UuidDefinition;

public class UuidField
implements PropertyElement {
    private final UuidDefinition uuidDefinition;
    private final ValueProvider valueProvider;

    public UuidField(UuidDefinition uuidDefinition, ValueProvider valueProvider) {
        this.uuidDefinition = (UuidDefinition)Preconditions.checkNotNull((Object)uuidDefinition, (Object)"uuidDefinition is null");
        this.valueProvider = (ValueProvider)Preconditions.checkNotNull((Object)valueProvider, (Object)"valueProvider is null");
    }

    public static List<UuidField> createUuids(ValueCache valueCache, UuidDefinition ... uuidDefinitions) throws IOException {
        Preconditions.checkNotNull((Object)valueCache, (Object)"valueCache is null");
        ImmutableList.Builder result = ImmutableList.builder();
        for (UuidDefinition uuidDefinition : uuidDefinitions) {
            uuidDefinition.check();
            ValueProvider uuidValue = valueCache.getValueProvider(uuidDefinition);
            UuidField uuidField = new UuidField(uuidDefinition, uuidValue);
            result.add((Object)uuidField);
        }
        return result.build();
    }

    @Override
    public String getPropertyName() {
        return this.uuidDefinition.getId();
    }

    @Override
    public Optional<String> getPropertyValue() {
        Optional<UUID> definedValue;
        UUID result = null;
        Optional<String> propValue = this.valueProvider.getValue();
        if (propValue.isPresent()) {
            result = UUID.fromString(propValue.get());
        }
        if (result == null && (definedValue = this.uuidDefinition.getValue()).isPresent()) {
            result = definedValue.get();
        }
        if (result == null) {
            result = UUID.randomUUID();
        }
        this.valueProvider.setValue(result.toString());
        return this.uuidDefinition.formatResult(result.toString());
    }

    @Override
    public boolean isExport() {
        return this.uuidDefinition.isExport();
    }

    public String toString() {
        return this.getPropertyValue().orElse("");
    }
}

