/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.propertyhelper;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import org.basepom.mojo.propertyhelper.ValueProvider;
import org.basepom.mojo.propertyhelper.beans.AbstractDefinition;
import org.basepom.mojo.propertyhelper.beans.IgnoreWarnFailCreate;
import org.basepom.mojo.propertyhelper.util.Log;

public final class ValueCache {
    private static final Log LOG = Log.findLog();
    private final Map<String, String> ephemeralValues = Maps.newHashMap();
    private final Map<File, ValueCacheEntry> valueFiles = Maps.newHashMap();

    @VisibleForTesting
    static ValueProvider findCurrentValueProvider(Map<String, String> values, AbstractDefinition<?> definition) {
        Preconditions.checkNotNull(values, (Object)"values is null");
        String name = definition.getPropertyName();
        boolean hasValue = values.containsKey(name);
        boolean createProperty = IgnoreWarnFailCreate.checkState(definition.getOnMissingProperty(), hasValue, name);
        if (hasValue) {
            return new ValueProvider.MapValueProvider(values, name);
        }
        if (createProperty) {
            if (definition.getInitialValue().isPresent()) {
                values.put(name, definition.getInitialValue().get());
            }
            return new ValueProvider.MapValueProvider(values, name);
        }
        return ValueProvider.NULL_PROVIDER;
    }

    public ValueProvider getValueProvider(AbstractDefinition<?> definition) throws IOException {
        Optional<Map<String, String>> values = this.getValues(definition);
        if (values.isEmpty()) {
            String name = definition.getPropertyName();
            Optional<String> value = definition.getInitialValue();
            value.ifPresent(s -> this.ephemeralValues.put(name, (String)s));
            return new ValueProvider.MapValueProvider(this.ephemeralValues, name);
        }
        return ValueCache.findCurrentValueProvider(values.get(), definition);
    }

    @VisibleForTesting
    Optional<Map<String, String>> getValues(AbstractDefinition<?> definition) throws IOException {
        Optional<File> definitionFile = definition.getPropertyFile();
        if (definitionFile.isEmpty()) {
            return Optional.empty();
        }
        File canonicalFile = definitionFile.get().getCanonicalFile();
        boolean createFile = IgnoreWarnFailCreate.checkState(definition.getOnMissingFile(), canonicalFile.exists(), definitionFile.get().getCanonicalPath());
        ValueCacheEntry cacheEntry = this.valueFiles.get(canonicalFile);
        if (cacheEntry != null) {
            if (createFile) {
                cacheEntry.doCreate();
            }
        } else {
            Properties props = new Properties();
            if (!canonicalFile.exists()) {
                cacheEntry = new ValueCacheEntry(props, false, createFile);
                this.valueFiles.put(canonicalFile, cacheEntry);
            } else if (canonicalFile.isFile() && canonicalFile.canRead()) {
                try (InputStream stream = Files.newInputStream(canonicalFile.toPath(), new OpenOption[0]);){
                    props.load(stream);
                    cacheEntry = new ValueCacheEntry(props, true, createFile);
                    this.valueFiles.put(canonicalFile, cacheEntry);
                }
            } else {
                throw new IllegalStateException(String.format("Can not load %s, not a file!", definitionFile.get().getCanonicalPath()));
            }
        }
        return Optional.of(cacheEntry.getValues());
    }

    public void persist() throws IOException {
        for (Map.Entry<File, ValueCacheEntry> entries : this.valueFiles.entrySet()) {
            File folder;
            ValueCacheEntry entry = entries.getValue();
            if (!entry.isDirty()) continue;
            File file = entries.getKey();
            if (!entry.isExists() && !entry.isCreate()) continue;
            Preconditions.checkNotNull((Object)file, (Object)"no file defined, can not persist!");
            File oldFile = new File(file.getCanonicalPath() + ".bak");
            if (entry.isExists()) {
                Preconditions.checkState((boolean)file.exists(), (String)"'%s' should exist!", (Object)file.getCanonicalPath());
                if (oldFile.exists()) {
                    Preconditions.checkState((boolean)oldFile.delete(), (String)"Could not delete '%s'", (Object)file.getCanonicalPath());
                }
            }
            if (!(folder = file.getParentFile()).exists()) {
                Preconditions.checkState((boolean)folder.mkdirs(), (String)"Could not create folder '%s'", (Object)folder.getCanonicalPath());
            }
            File newFile = new File(file.getCanonicalPath() + ".new");
            try (OutputStream stream = Files.newOutputStream(newFile.toPath(), new OpenOption[0]);){
                entry.store(stream, "created by property-helper-maven-plugin");
            }
            if (file.exists() && !file.renameTo(oldFile)) {
                LOG.warn("Could not rename '%s' to '%s'!", file, oldFile);
            }
            if (file.exists() || newFile.renameTo(file)) continue;
            LOG.warn("Could not rename '%s' to '%s'!", newFile, file);
        }
    }

    public static class ValueCacheEntry {
        private final Map<String, String> values = Maps.newHashMap();
        private final boolean exists;
        private boolean create;
        private boolean dirty = false;

        ValueCacheEntry(@Nonnull Properties props, boolean exists, boolean create) {
            Preconditions.checkNotNull((Object)props, (Object)"props is null");
            this.values.putAll((Map<String, String>)Maps.fromProperties((Properties)props));
            this.exists = exists;
            this.create = create;
        }

        public void store(OutputStream out, String comment) throws IOException {
            Properties p = new Properties();
            for (Map.Entry<String, String> entry : this.values.entrySet()) {
                p.setProperty(entry.getKey(), entry.getValue());
            }
            p.store(out, comment);
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public void dirty() {
            this.dirty = true;
        }

        public Map<String, String> getValues() {
            return new ForwardingMap<String, String>(){

                protected Map<String, String> delegate() {
                    return values;
                }

                public String remove(Object object) {
                    this.dirty();
                    return (String)super.remove(object);
                }

                public void clear() {
                    this.dirty();
                    super.clear();
                }

                public String put(String key, String value) {
                    String oldValue = (String)super.put((Object)key, (Object)value);
                    if (!Objects.equals(value, oldValue)) {
                        this.dirty();
                    }
                    return oldValue;
                }

                public void putAll(Map<? extends String, ? extends String> map) {
                    this.dirty();
                    super.putAll(map);
                }
            };
        }

        public boolean isExists() {
            return this.exists;
        }

        public boolean isCreate() {
            return this.create;
        }

        public void doCreate() {
            this.create = true;
            this.dirty();
        }

        public String toString() {
            return new StringJoiner(", ", ValueCacheEntry.class.getSimpleName() + "[", "]").add("values=" + this.values).add("exists=" + this.exists).add("create=" + this.create).add("dirty=" + this.dirty).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ValueCacheEntry that = (ValueCacheEntry)o;
            return this.exists == that.exists && this.create == that.create && this.dirty == that.dirty && Objects.equals(this.values, that.values);
        }

        public int hashCode() {
            return Objects.hash(this.values, this.exists, this.create, this.dirty);
        }
    }
}

