/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.propertyhelper.beans;

import com.google.common.base.Preconditions;
import java.util.Locale;
import org.basepom.mojo.propertyhelper.util.Log;

public enum IgnoreWarnFail {
    IGNORE,
    WARN,
    FAIL;

    private static final Log LOG;

    public static IgnoreWarnFail forString(String value) {
        Preconditions.checkNotNull((Object)value, (Object)"the value can not be null");
        return Enum.valueOf(IgnoreWarnFail.class, value.toUpperCase(Locale.ENGLISH));
    }

    public static void checkState(IgnoreWarnFail iwf, boolean exists, String thing) {
        if (exists) {
            return;
        }
        switch (iwf) {
            case IGNORE: {
                return;
            }
            case WARN: {
                LOG.warn("'%s' does not exist!", thing);
                break;
            }
            case FAIL: {
                throw new IllegalStateException(String.format("'%s' does not exist!", thing));
            }
            default: {
                throw new IllegalStateException("Unknown state: " + iwf);
            }
        }
    }

    static {
        LOG = Log.findLog();
    }
}

