/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.propertyhelper.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Log {
    private static final String LOG_NAME = Log.class.getName();
    private final Logger wrappedLogger;

    private Log(Logger wrappedLogger) {
        this.wrappedLogger = (Logger)Preconditions.checkNotNull((Object)wrappedLogger, (Object)"wrappedLogger is null");
    }

    public static Log findLog() {
        return Log.findLog(0);
    }

    public static Log findCallerLog() {
        return Log.findLog(1);
    }

    public static Log forClass(Class<?> clazz) {
        return Log.forName(clazz.getName());
    }

    public static Log forName(String name) {
        return new Log(LoggerFactory.getLogger((String)name));
    }

    public static Log forLogger(Logger wrappedLogger) {
        return new Log(wrappedLogger);
    }

    private static Log findLog(int depth) {
        int i;
        StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
        for (i = 1; i < stacktrace.length && stacktrace[i].getClassName().equals(LOG_NAME); ++i) {
        }
        if (i + depth < stacktrace.length) {
            return Log.forName(stacktrace[i + depth].getClassName());
        }
        throw new IllegalStateException(String.format("Attempt to generate a logger for an invalid depth (%d vs. %d).", depth, stacktrace.length - i));
    }

    @VisibleForTesting
    Logger getWrappedLogger() {
        return this.wrappedLogger;
    }

    public boolean isTraceEnabled() {
        return this.wrappedLogger.isTraceEnabled();
    }

    public boolean isDebugEnabled() {
        return this.wrappedLogger.isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return this.wrappedLogger.isErrorEnabled();
    }

    public boolean isWarnEnabled() {
        return this.wrappedLogger.isWarnEnabled();
    }

    public boolean isInfoEnabled() {
        return this.wrappedLogger.isInfoEnabled();
    }

    public void trace(Throwable t, String message, Object ... args) {
        if (this.wrappedLogger.isTraceEnabled()) {
            this.wrappedLogger.trace(String.format(message, args), t);
        }
    }

    public void trace(String message, Throwable t, Object ... args) {
        this.trace(t, message, args);
    }

    public void trace(Throwable t, String message) {
        this.wrappedLogger.trace(message, t);
    }

    public void trace(String message) {
        this.wrappedLogger.trace(message);
    }

    public void trace(String message, Object ... args) {
        if (this.wrappedLogger.isTraceEnabled()) {
            this.wrappedLogger.trace(String.format(message, args));
        }
    }

    public void debug(Throwable t, String message, Object ... args) {
        if (this.wrappedLogger.isDebugEnabled()) {
            this.wrappedLogger.debug(String.format(message, args), t);
        }
    }

    public void debug(String message, Throwable t, Object ... args) {
        this.debug(t, message, args);
    }

    public void debug(Throwable t, String message) {
        this.wrappedLogger.debug(message, t);
    }

    public void debug(String message) {
        this.wrappedLogger.debug(message);
    }

    public void debug(String message, Object ... args) {
        if (this.wrappedLogger.isDebugEnabled()) {
            this.wrappedLogger.debug(String.format(message, args));
        }
    }

    public void info(Throwable t, String message, Object ... args) {
        if (this.wrappedLogger.isInfoEnabled()) {
            this.wrappedLogger.info(String.format(message, args), t);
        }
    }

    public void info(String message, Throwable t, Object ... args) {
        this.info(t, message, args);
    }

    public void info(Throwable t, String message) {
        this.wrappedLogger.info(message, t);
    }

    public void info(String message, Object ... args) {
        if (this.wrappedLogger.isInfoEnabled()) {
            this.wrappedLogger.info(String.format(message, args));
        }
    }

    public void info(String message) {
        this.wrappedLogger.info(message);
    }

    public void infoDebug(Throwable t, String infoMessage, Object ... args) {
        if (this.wrappedLogger.isDebugEnabled()) {
            this.wrappedLogger.info(String.format(infoMessage, args), t);
        } else if (this.wrappedLogger.isInfoEnabled()) {
            this.wrappedLogger.info(this.summarize(t, infoMessage, args));
        }
    }

    public void infoDebug(String infoMessage, Throwable t, Object ... args) {
        this.infoDebug(t, infoMessage, args);
    }

    public void infoDebug(Throwable t, String infoMessage) {
        if (this.wrappedLogger.isDebugEnabled()) {
            this.wrappedLogger.info(infoMessage, t);
        } else {
            this.wrappedLogger.info(this.summarize(t, infoMessage, new Object[0]));
        }
    }

    public void warn(Throwable t, String message, Object ... args) {
        this.wrappedLogger.warn(String.format(message, args), t);
    }

    public void warn(String message, Throwable t, Object ... args) {
        this.warn(t, message, args);
    }

    public void warn(Throwable t, String message) {
        this.wrappedLogger.warn(message, t);
    }

    public void warn(String message, Object ... args) {
        this.wrappedLogger.warn(String.format(message, args));
    }

    public void warn(String message) {
        this.wrappedLogger.warn(message);
    }

    public void warnDebug(Throwable t, String warnMessage, Object ... args) {
        if (this.wrappedLogger.isDebugEnabled()) {
            this.wrappedLogger.warn(String.format(warnMessage, args), t);
        } else if (this.isWarnEnabled()) {
            this.wrappedLogger.warn(this.summarize(t, warnMessage, args));
        }
    }

    public void warnDebug(String warnMessage, Throwable t, Object ... args) {
        this.warnDebug(t, warnMessage, args);
    }

    public void warnDebug(Throwable t, String warnMessage) {
        if (this.wrappedLogger.isDebugEnabled()) {
            this.wrappedLogger.warn(warnMessage, t);
        } else {
            this.wrappedLogger.warn(this.summarize(t, warnMessage, new Object[0]));
        }
    }

    public void error(Throwable t, String message, Object ... args) {
        this.wrappedLogger.error(String.format(message, args), t);
    }

    public void error(String message, Throwable t, Object ... args) {
        this.error(t, message, args);
    }

    public void error(Throwable t, String message) {
        this.wrappedLogger.error(message, t);
    }

    public void error(String message, Object ... args) {
        this.wrappedLogger.error(String.format(message, args));
    }

    public void error(String message) {
        this.wrappedLogger.error(message);
    }

    public void errorDebug(Throwable t, String errorMessage, Object ... args) {
        if (this.wrappedLogger.isDebugEnabled()) {
            this.wrappedLogger.error(String.format(errorMessage, args), t);
        } else if (this.isErrorEnabled()) {
            this.wrappedLogger.error(this.summarize(t, errorMessage, args));
        }
    }

    public void errorDebug(String errorMessage, Throwable t, Object ... args) {
        this.errorDebug(t, errorMessage, args);
    }

    public void errorDebug(Throwable t, String errorMessage) {
        if (this.wrappedLogger.isDebugEnabled()) {
            this.wrappedLogger.error(errorMessage, t);
        } else {
            this.wrappedLogger.error(this.summarize(t, errorMessage, new Object[0]));
        }
    }

    private String summarize(Throwable t, String format, Object ... args) {
        String message;
        String string = message = t == null ? null : t.getMessage();
        if (message == null) {
            return this.format(format, args);
        }
        int index = message.indexOf(10);
        if (index == -1) {
            return this.format(format, args) + ": " + message;
        }
        String shortMsg = message.substring(0, index);
        return this.format(format, args) + " (Switch to DEBUG for full stack trace): " + shortMsg;
    }

    private String format(String format, Object ... args) {
        if (format != null) {
            return String.format(format, args);
        }
        StringBuilder sb = new StringBuilder();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                sb.append(args[i]);
                if (i >= args.length - 1) continue;
                sb.append(", ");
            }
        }
        return sb.toString();
    }
}

