/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.propertyhelper;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.StringJoiner;

public interface ValueProvider {
    public static final ValueProvider NULL_PROVIDER = Optional::empty;

    public Optional<String> getValue();

    default public void setValue(String value) {
    }

    public static class PropertyBackedValueAdapter
    implements ValueProvider {
        private final Properties props;
        private final String propertyName;

        public PropertyBackedValueAdapter(Properties props, String propertyName) {
            this.props = props;
            this.propertyName = (String)Preconditions.checkNotNull((Object)propertyName, (Object)"propertyName is null");
        }

        @Override
        public Optional<String> getValue() {
            return Optional.ofNullable(this.props.getProperty(this.propertyName));
        }

        @Override
        public void setValue(String value) {
            Preconditions.checkNotNull((Object)value, (Object)"value is null");
            this.props.setProperty(this.propertyName, value);
        }

        public String toString() {
            return new StringJoiner(", ", PropertyBackedValueAdapter.class.getSimpleName() + "[", "]").add("props=" + this.props).add("propertyName='" + this.propertyName + "'").toString();
        }
    }

    public static class MapBackedValueAdapter
    implements ValueProvider {
        private final Map<String, String> values;
        private final String valueName;

        MapBackedValueAdapter(Map<String, String> values, String valueName) {
            this.valueName = (String)Preconditions.checkNotNull((Object)valueName, (Object)"valueName is null");
            this.values = values;
        }

        @Override
        public Optional<String> getValue() {
            return Optional.ofNullable(this.values.get(this.valueName));
        }

        @Override
        public void setValue(String value) {
            Preconditions.checkNotNull((Object)value, (Object)"value is null");
            this.values.put(this.valueName, value);
        }

        public String toString() {
            return new StringJoiner(", ", MapBackedValueAdapter.class.getSimpleName() + "[", "]").add("values=" + this.values).add("valueName='" + this.valueName + "'").toString();
        }
    }

    public static class SingleValueProvider
    implements ValueProvider {
        private String value;

        @Override
        public Optional<String> getValue() {
            return Optional.ofNullable(this.value);
        }

        @Override
        public void setValue(String value) {
            this.value = value;
        }

        public String toString() {
            return new StringJoiner(", ", SingleValueProvider.class.getSimpleName() + "[", "]").add("value='" + this.value + "'").toString();
        }
    }
}

