/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.propertyhelper.definitions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.StringJoiner;
import org.basepom.mojo.propertyhelper.FieldContext;
import org.basepom.mojo.propertyhelper.ValueCache;
import org.basepom.mojo.propertyhelper.ValueProvider;
import org.basepom.mojo.propertyhelper.definitions.FieldDefinition;
import org.basepom.mojo.propertyhelper.fields.MacroField;

public class MacroDefinition
extends FieldDefinition<String> {
    String macroType = null;
    String macroClass = null;
    Properties properties = new Properties();

    public MacroDefinition() {
    }

    @VisibleForTesting
    MacroDefinition(String id) {
        super(id);
    }

    public Optional<String> getMacroType() {
        return Optional.ofNullable(this.macroType);
    }

    public Optional<String> getMacroClass() {
        return Optional.ofNullable(this.macroClass);
    }

    public Map<String, String> getProperties() {
        return ImmutableMap.copyOf((Map)Maps.fromProperties((Properties)this.properties));
    }

    @Override
    public void check() {
        super.check();
        Preconditions.checkState((this.macroClass != null || this.macroType != null ? 1 : 0) != 0, (Object)"neither macro class nor macro type is defined!");
    }

    @Override
    public MacroField createField(FieldContext context, ValueCache valueCache) throws IOException {
        Preconditions.checkNotNull((Object)context, (Object)"context is null");
        Preconditions.checkNotNull((Object)valueCache, (Object)"valueCache is null");
        this.check();
        ValueProvider macroValue = valueCache.getValueProvider(this);
        return new MacroField(this, macroValue, context);
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", MacroDefinition.class.getSimpleName() + "[", "]").add("macroType='" + this.macroType + "'").add("macroClass='" + this.macroClass + "'").add("properties=" + this.properties).add(super.toString()).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MacroDefinition that = (MacroDefinition)o;
        return Objects.equals(this.macroType, that.macroType) && Objects.equals(this.macroClass, that.macroClass) && Objects.equals(this.properties, that.properties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.macroType, this.macroClass, this.properties);
    }
}

