/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.propertyhelper.definitions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import org.basepom.mojo.propertyhelper.FieldContext;
import org.basepom.mojo.propertyhelper.ValueCache;
import org.basepom.mojo.propertyhelper.ValueProvider;
import org.basepom.mojo.propertyhelper.definitions.FieldDefinition;
import org.basepom.mojo.propertyhelper.fields.NumberField;

public class NumberDefinition
extends FieldDefinition<String> {
    public static final String INITIAL_VALUE = "0";
    Integer fieldNumber;
    int increment = 1;

    public NumberDefinition() {
        this.initialValue = INITIAL_VALUE;
    }

    @VisibleForTesting
    NumberDefinition(String id) {
        super(id);
        this.initialValue = INITIAL_VALUE;
    }

    public Optional<Integer> getFieldNumber() {
        return Optional.ofNullable(this.fieldNumber);
    }

    public int getIncrement() {
        return this.increment;
    }

    @Override
    public void check() {
        super.check();
        Preconditions.checkState((boolean)this.getInitialValue().isPresent(), (Object)"initial value must be defined");
        this.getFieldNumber().ifPresent(fieldNumber -> Preconditions.checkState((fieldNumber >= 0 ? 1 : 0) != 0, (Object)"the field number must be >= 0"));
    }

    @Override
    public NumberField createField(FieldContext context, ValueCache valueCache) throws IOException {
        Preconditions.checkNotNull((Object)context, (Object)"context is null");
        Preconditions.checkNotNull((Object)valueCache, (Object)"valueCache is null");
        this.check();
        ValueProvider numberValue = valueCache.getValueProvider(this);
        return new NumberField(this, numberValue, context);
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", NumberDefinition.class.getSimpleName() + "[", "]").add("fieldNumber=" + this.fieldNumber).add("increment=" + this.increment).add(super.toString()).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NumberDefinition that = (NumberDefinition)o;
        return this.increment == that.increment && Objects.equals(this.fieldNumber, that.fieldNumber);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.fieldNumber, this.increment);
    }
}

