/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.propertyhelper.fields;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import org.basepom.mojo.propertyhelper.Field;
import org.basepom.mojo.propertyhelper.FieldContext;
import org.basepom.mojo.propertyhelper.ValueProvider;
import org.basepom.mojo.propertyhelper.definitions.NumberDefinition;

public final class NumberField
extends Field<String, NumberDefinition> {
    private final ValueProvider valueProvider;
    private List<NumberElement> numberElements;
    private List<NumberElement> numberIndex;

    @VisibleForTesting
    public static NumberField forTesting(NumberDefinition numberDefinition, ValueProvider valueProvider) {
        return new NumberField(numberDefinition, valueProvider, FieldContext.forTesting());
    }

    public NumberField(NumberDefinition fieldDefinition, ValueProvider valueProvider, FieldContext fieldContext) {
        super(fieldDefinition, fieldContext);
        this.valueProvider = valueProvider;
    }

    @Override
    public String getFieldName() {
        return ((NumberDefinition)this.fieldDefinition).getId();
    }

    @Override
    public String getValue() {
        this.parse();
        return this.formatResult(this.value().map(v -> Long.toString(v)).orElse(this.valueProvider.getValue().orElse("")));
    }

    private void parse() {
        String numberValue;
        Optional<String> value = this.valueProvider.getValue();
        ImmutableList.Builder numberELementBuilder = ImmutableList.builder();
        ImmutableList.Builder numberIndexBuilder = ImmutableList.builder();
        if (value.isPresent() && !(numberValue = value.get()).isBlank()) {
            int charIndex;
            StringBuilder sb = new StringBuilder();
            boolean number = Character.isDigit(numberValue.charAt(charIndex));
            for (charIndex = 0; charIndex < numberValue.length(); ++charIndex) {
                char currentChar = numberValue.charAt(charIndex);
                if (number != Character.isDigit(currentChar)) {
                    NumberElement numberElement = new NumberElement(number, sb.toString());
                    numberELementBuilder.add((Object)numberElement);
                    if (number) {
                        numberIndexBuilder.add((Object)numberElement);
                    }
                    number = !number;
                    sb.setLength(0);
                }
                sb.append(currentChar);
            }
            if (sb.length() > 0) {
                NumberElement numberElement = new NumberElement(number, sb.toString());
                numberELementBuilder.add((Object)numberElement);
                if (number) {
                    numberIndexBuilder.add((Object)numberElement);
                }
            }
        }
        this.numberElements = numberELementBuilder.build();
        this.numberIndex = numberIndexBuilder.build();
    }

    private String print() {
        return Joiner.on((String)"").join(this.numberElements.stream().map(NumberElement::getFieldValue).iterator());
    }

    private Optional<Long> value() {
        return ((NumberDefinition)this.fieldDefinition).getFieldNumber().map(fieldNumber -> this.numberIndex.get((int)fieldNumber)).flatMap(NumberElement::getLongValue);
    }

    private void set(long value) {
        Optional<NumberElement> numberElement = ((NumberDefinition)this.fieldDefinition).getFieldNumber().map(fieldNumber -> this.numberIndex.get((int)fieldNumber));
        if (numberElement.isPresent()) {
            numberElement.get().setLongValue(value);
            this.valueProvider.setValue(this.print());
        } else {
            this.valueProvider.setValue(Long.toString(value));
        }
    }

    public void increment() {
        this.parse();
        ((NumberDefinition)this.fieldDefinition).getFieldNumber().ifPresent(fieldNumber -> Preconditions.checkState((this.numberIndex.size() > fieldNumber ? 1 : 0) != 0, (String)"Only %s fields in %s, field %s requested.", (Object)this.numberElements.size(), (Object)this.print(), (Object)fieldNumber));
        this.value().ifPresent(value -> this.set(value + (long)((NumberDefinition)this.fieldDefinition).getIncrement()));
    }

    public Optional<Long> getNumberValue() {
        this.parse();
        ((NumberDefinition)this.fieldDefinition).getFieldNumber().ifPresent(fieldNumber -> Preconditions.checkState((this.numberIndex.size() > fieldNumber ? 1 : 0) != 0, (String)"Only %s fields in %s, field %s requested.", (Object)this.numberElements.size(), (Object)this.print(), (Object)fieldNumber));
        return this.value();
    }

    public String toString() {
        return new StringJoiner(", ", NumberField.class.getSimpleName() + "[", "]").add("valueProvider=" + this.valueProvider).add("numberElements=" + this.numberElements).add("numberIndex=" + this.numberIndex).add("fieldDefinition=" + this.fieldDefinition).toString();
    }

    private static final class NumberElement {
        private final boolean number;
        private String value;

        private NumberElement(boolean number, String value) {
            this.number = number;
            this.value = value;
        }

        String getFieldValue() {
            return this.value;
        }

        void setLongValue(long value) {
            this.value = Long.toString(value);
        }

        Optional<Long> getLongValue() {
            return this.number ? Optional.of(Long.parseLong(this.value)) : Optional.empty();
        }

        public String toString() {
            return new StringJoiner(", ", NumberElement.class.getSimpleName() + "[", "]").add("number=" + this.number).add("value='" + this.value + "'").toString();
        }
    }
}

