/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.propertyhelper;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.flogger.FluentLogger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import javax.inject.Inject;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.basepom.mojo.propertyhelper.Field;
import org.basepom.mojo.propertyhelper.FieldContext;
import org.basepom.mojo.propertyhelper.IgnoreWarnFail;
import org.basepom.mojo.propertyhelper.InterpolatorFactory;
import org.basepom.mojo.propertyhelper.RandomUtil;
import org.basepom.mojo.propertyhelper.TransformerRegistry;
import org.basepom.mojo.propertyhelper.ValueCache;
import org.basepom.mojo.propertyhelper.definitions.DateDefinition;
import org.basepom.mojo.propertyhelper.definitions.FieldDefinition;
import org.basepom.mojo.propertyhelper.definitions.MacroDefinition;
import org.basepom.mojo.propertyhelper.definitions.NumberDefinition;
import org.basepom.mojo.propertyhelper.definitions.PropertyGroupDefinition;
import org.basepom.mojo.propertyhelper.definitions.StringDefinition;
import org.basepom.mojo.propertyhelper.definitions.UuidDefinition;
import org.basepom.mojo.propertyhelper.fields.NumberField;
import org.basepom.mojo.propertyhelper.groups.PropertyGroup;
import org.basepom.mojo.propertyhelper.groups.PropertyResult;
import org.basepom.mojo.propertyhelper.macros.MacroType;

public abstract class AbstractPropertyHelperMojo
extends AbstractMojo
implements FieldContext {
    private static final FluentLogger LOG = FluentLogger.forEnclosingClass();
    protected final ValueCache valueCache = new ValueCache();
    private IgnoreWarnFail onDuplicateField = IgnoreWarnFail.FAIL;
    private List<String> activeGroups = List.of();
    private List<PropertyGroupDefinition> propertyGroupDefinitions = List.of();
    private List<NumberDefinition> numberDefinitions = List.of();
    private List<StringDefinition> stringDefinitions = List.of();
    private List<DateDefinition> dateDefinitions = List.of();
    private List<MacroDefinition> macroDefinitions = List.of();
    private List<UuidDefinition> uuidDefinitions = List.of();
    @Parameter(defaultValue="false")
    boolean skip;
    @Parameter(defaultValue="${project}", readonly=true)
    MavenProject project;
    @Parameter(defaultValue="${settings}", readonly=true)
    Settings settings;
    @Parameter(required=true, readonly=true, defaultValue="${project.basedir}")
    File basedir;
    @Parameter(defaultValue="${project.build.outputTimestamp}")
    String outputTimestamp;
    private Map<String, MacroType> macroMap = Map.of();
    private boolean isSnapshot;
    private InterpolatorFactory interpolatorFactory;
    private TransformerRegistry transformerRegistry;
    private Map<String, FieldDefinition<?>> fieldDefinitions = Map.of();
    private List<NumberField> numberFields = List.of();
    private Map<String, String> values = Map.of();
    private Random random;

    @Parameter(defaultValue="fail", alias="onDuplicateProperty")
    public void setOnDuplicateField(String onDuplicateField) {
        this.onDuplicateField = IgnoreWarnFail.forString(onDuplicateField);
    }

    @Parameter
    public void setActiveGroups(String ... activeGroups) {
        this.activeGroups = Arrays.asList(activeGroups);
    }

    @Parameter
    public void setPropertyGroups(PropertyGroupDefinition ... propertyGroups) {
        this.propertyGroupDefinitions = Arrays.asList(propertyGroups);
    }

    @Parameter
    public void setNumbers(NumberDefinition ... numberDefinitions) {
        this.numberDefinitions = Arrays.asList(numberDefinitions);
    }

    @Parameter
    public void setStrings(StringDefinition ... stringDefinitions) {
        this.stringDefinitions = Arrays.asList(stringDefinitions);
    }

    @Parameter
    public void setDates(DateDefinition ... dateDefinitions) {
        this.dateDefinitions = Arrays.asList(dateDefinitions);
    }

    @Parameter
    public void setMacros(MacroDefinition ... macroDefinitions) {
        this.macroDefinitions = Arrays.asList(macroDefinitions);
    }

    @Parameter
    public void setUuids(UuidDefinition ... uuidDefinitions) {
        this.uuidDefinitions = Arrays.asList(uuidDefinitions);
    }

    @Inject
    public void setMacroMap(Map<String, MacroType> macroMap) {
        this.macroMap = ImmutableMap.copyOf(macroMap);
    }

    public void execute() throws MojoExecutionException {
        this.isSnapshot = this.project.getArtifact().isSnapshot();
        this.interpolatorFactory = new InterpolatorFactory(this.project.getModel());
        this.transformerRegistry = TransformerRegistry.INSTANCE;
        ((FluentLogger.Api)LOG.atFine()).log("Current build is a %s project.", (Object)(this.isSnapshot ? "snapshot" : "release"));
        ((FluentLogger.Api)LOG.atFiner()).log("On duplicate field definitions: %s", (Object)this.onDuplicateField);
        try {
            if (this.skip) {
                ((FluentLogger.Api)LOG.atFine()).log("skipping plugin execution!");
            } else {
                this.random = RandomUtil.createRandomFromSeed(this.outputTimestamp);
                this.doExecute();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("While running mojo: ", (Exception)e);
        }
    }

    @Override
    public MavenProject getProject() {
        return this.project;
    }

    @Override
    public File getBasedir() {
        return this.basedir;
    }

    @Override
    public Settings getSettings() {
        return this.settings;
    }

    @Override
    public Map<String, MacroType> getMacros() {
        return this.macroMap;
    }

    @Override
    public Properties getProjectProperties() {
        return this.project.getProperties();
    }

    @Override
    public InterpolatorFactory getInterpolatorFactory() {
        return this.interpolatorFactory;
    }

    @Override
    public TransformerRegistry getTransformerRegistry() {
        return this.transformerRegistry;
    }

    @Override
    public Random getRandom() {
        return this.random;
    }

    protected List<NumberField> getNumbers() {
        return this.numberFields;
    }

    protected abstract void doExecute() throws IOException, MojoExecutionException;

    private void addDefinitions(ImmutableMap.Builder<String, FieldDefinition<?>> builder, List<? extends FieldDefinition<?>> newDefinitions) {
        ImmutableMap existingDefinitions = builder.build();
        for (FieldDefinition<?> definition : newDefinitions) {
            String propertyName;
            if (definition.isSkip() || !IgnoreWarnFail.checkIgnoreWarnFailState(!existingDefinitions.containsKey(propertyName = definition.getId()), this.onDuplicateField, () -> String.format("field definition '%s' does not exist", propertyName), () -> String.format("field definition '%s' already exists!", propertyName))) continue;
            builder.put((Object)propertyName, definition);
        }
    }

    protected void createFieldDefinitions() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.addDefinitions(builder, this.numberDefinitions);
        this.addDefinitions(builder, this.stringDefinitions);
        this.addDefinitions(builder, this.macroDefinitions);
        this.addDefinitions(builder, this.dateDefinitions);
        this.addDefinitions(builder, this.uuidDefinitions);
        this.fieldDefinitions = builder.build();
    }

    protected void createFields() throws MojoExecutionException, IOException {
        ImmutableList.Builder numberFields = ImmutableList.builder();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (FieldDefinition<?> definition : this.fieldDefinitions.values()) {
            Object field = definition.createField(this, this.valueCache);
            if (field instanceof NumberField) {
                numberFields.add((Object)((NumberField)field));
            }
            String fieldValue = ((Field)field).getValue();
            builder.put((Object)((Field)field).getFieldName(), (Object)fieldValue);
            if (((Field)field).isExposeAsProperty()) {
                this.project.getProperties().setProperty(((Field)field).getFieldName(), fieldValue);
                ((FluentLogger.Api)LOG.atFine()).log("Exporting Property name: %s, value: %s", (Object)((Field)field).getFieldName(), (Object)fieldValue);
                continue;
            }
            ((FluentLogger.Api)LOG.atFine()).log("Property name: %s, value: %s", (Object)((Field)field).getFieldName(), (Object)fieldValue);
        }
        this.numberFields = numberFields.build();
        this.values = builder.build();
    }

    @SuppressFBWarnings(value={"WMI_WRONG_MAP_ITERATOR"})
    public void createGroups() {
        ImmutableMap.Builder groupMapBuilder = ImmutableMap.builder();
        ImmutableMap.Builder resultMapBuilder = ImmutableMap.builder();
        Set exportedFields = (Set)this.fieldDefinitions.values().stream().filter(FieldDefinition::isExport).map(FieldDefinition::getId).collect(ImmutableSet.toImmutableSet());
        LinkedHashSet propertyNames = new LinkedHashSet(exportedFields);
        this.propertyGroupDefinitions.forEach(propertyGroupDefinition -> {
            PropertyGroup propertyGroup = propertyGroupDefinition.createGroup(this);
            Set<PropertyResult> propertyResults = propertyGroup.createProperties(this.values);
            groupMapBuilder.put((Object)propertyGroup.getId(), (Object)propertyGroup);
            resultMapBuilder.put((Object)propertyGroup.getId(), propertyResults);
        });
        ImmutableMap groupMap = groupMapBuilder.build();
        ImmutableMap resultMap = resultMapBuilder.build();
        Object groupsToAdd = this.activeGroups == null ? groupMap.keySet() : this.activeGroups;
        Iterator iterator = groupsToAdd.iterator();
        while (iterator.hasNext()) {
            String groupToAdd = (String)iterator.next();
            PropertyGroup activeGroup = (PropertyGroup)groupMap.get((Object)groupToAdd);
            Preconditions.checkState((activeGroup != null ? 1 : 0) != 0, (String)"activated group '%s' does not exist", (Object)groupToAdd);
            Set activeResult = (Set)resultMap.get((Object)groupToAdd);
            Preconditions.checkState((activeResult != null ? 1 : 0) != 0, (String)"activated group '%s' has no result", (Object)groupToAdd);
            if (activeGroup.checkActive(this.isSnapshot)) {
                for (PropertyResult propertyResult : activeResult) {
                    String propertyName = propertyResult.getPropertyName();
                    if (!IgnoreWarnFail.checkIgnoreWarnFailState(!propertyNames.contains(propertyName), activeGroup.getOnDuplicateProperty(), () -> String.format("property '%s' is not exposed", propertyName), () -> String.format("property '%s' is already exposed!", propertyName))) continue;
                    this.project.getProperties().setProperty(propertyName, propertyResult.getPropertyValue());
                }
                continue;
            }
            ((FluentLogger.Api)LOG.atFine()).log("Skipping property group %s, not active", (Object)activeGroup);
        }
    }
}

