/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.propertyhelper;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import org.apache.maven.plugin.MojoExecutionException;
import org.basepom.mojo.propertyhelper.FieldContext;
import org.basepom.mojo.propertyhelper.InterpolatorFactory;
import org.basepom.mojo.propertyhelper.TransformerRegistry;
import org.basepom.mojo.propertyhelper.definitions.FieldDefinition;

public abstract class Field<T, U extends FieldDefinition<T>> {
    protected final U fieldDefinition;
    private final InterpolatorFactory interpolatorFactory;
    private final TransformerRegistry transformerRegistry;

    protected Field(U fieldDefinition, FieldContext context) {
        this.fieldDefinition = fieldDefinition;
        this.interpolatorFactory = context.getInterpolatorFactory();
        this.transformerRegistry = context.getTransformerRegistry();
    }

    public abstract String getFieldName();

    public abstract String getValue() throws MojoExecutionException;

    protected String formatResult(T value) {
        return Optional.ofNullable(value).map(((FieldDefinition)this.fieldDefinition).getPreFormat()).map(this.interpolatorFactory.interpolate(this.getFieldName(), ((FieldDefinition)this.fieldDefinition).getOnMissingProperty(), (Map<String, String>)ImmutableMap.of())).map(((FieldDefinition)this.fieldDefinition).getPostFormat()).map(((FieldDefinition)this.fieldDefinition).getRegexp()).map(this.transformerRegistry.applyTransformers(((FieldDefinition)this.fieldDefinition).getTransformers())).orElse("");
    }

    public boolean isExposeAsProperty() {
        return ((FieldDefinition)this.fieldDefinition).isExport();
    }
}

