/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.propertyhelper;

import com.google.common.base.Preconditions;
import com.google.common.flogger.FluentLogger;
import java.util.Locale;
import java.util.function.Supplier;

public enum IgnoreWarnFail {
    IGNORE,
    WARN,
    FAIL;

    private static final FluentLogger LOG;

    public static IgnoreWarnFail forString(String value) {
        Preconditions.checkNotNull((Object)value, (Object)"the value can not be null");
        return Enum.valueOf(IgnoreWarnFail.class, value.toUpperCase(Locale.getDefault()));
    }

    public static boolean checkIgnoreWarnFailState(boolean check, IgnoreWarnFail iwf, Supplier<String> checkMessage, Supplier<String> errorMessage) {
        if (check) {
            ((FluentLogger.Api)LOG.atFine()).log(checkMessage.get());
            return true;
        }
        switch (iwf) {
            case IGNORE: {
                ((FluentLogger.Api)LOG.atFine()).log(errorMessage.get());
                break;
            }
            case WARN: {
                ((FluentLogger.Api)LOG.atWarning()).log(errorMessage.get());
                break;
            }
            case FAIL: {
                throw new IllegalStateException(errorMessage.get());
            }
            default: {
                throw new IllegalStateException("Unknown state: " + iwf);
            }
        }
        return false;
    }

    static {
        LOG = FluentLogger.forEnclosingClass();
    }
}

