/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.propertyhelper;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.model.Model;
import org.basepom.mojo.propertyhelper.IgnoreWarnFail;
import org.basepom.mojo.propertyhelper.Sneaky;
import org.codehaus.plexus.interpolation.EnvarBasedValueSource;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.MapBasedValueSource;
import org.codehaus.plexus.interpolation.ObjectBasedValueSource;
import org.codehaus.plexus.interpolation.PrefixAwareRecursionInterceptor;
import org.codehaus.plexus.interpolation.PrefixedValueSourceWrapper;
import org.codehaus.plexus.interpolation.PropertiesBasedValueSource;
import org.codehaus.plexus.interpolation.RecursionInterceptor;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;

public final class InterpolatorFactory {
    private static final List<String> SYNONYM_PREFIXES = ImmutableList.of((Object)"project", (Object)"pom");
    private static final String PREFIX = "@{";
    private static final String POSTFIX = "}";
    private final Model model;

    public InterpolatorFactory(Model model) {
        this.model = (Model)Preconditions.checkNotNull((Object)model, (Object)"model is null");
    }

    public static InterpolatorFactory forTesting() {
        return new InterpolatorFactory(new Model());
    }

    public Function<String, String> interpolate(String name, IgnoreWarnFail onMissingField, Map<String, String> properties) {
        return value -> {
            try {
                return this.interpolate(name, (String)value, onMissingField, properties);
            }
            catch (Exception e) {
                throw Sneaky.throwAnyway(e);
            }
        };
    }

    private String interpolate(String name, String value, IgnoreWarnFail onMissingField, Map<String, String> properties) throws IOException, InterpolationException {
        Preconditions.checkNotNull((Object)name, (Object)"name is null");
        Preconditions.checkNotNull((Object)value, (Object)"value is null");
        Preconditions.checkNotNull(properties, (Object)"properties is null");
        StringSearchInterpolator interpolator = new StringSearchInterpolator(PREFIX, POSTFIX);
        interpolator.addValueSource((ValueSource)new EnvarBasedValueSource());
        interpolator.addValueSource((ValueSource)new PropertiesBasedValueSource(System.getProperties()));
        interpolator.addValueSource((ValueSource)new PrefixedValueSourceWrapper((ValueSource)new ObjectBasedValueSource((Object)this.model), SYNONYM_PREFIXES, true));
        interpolator.addValueSource((ValueSource)new PrefixedValueSourceWrapper((ValueSource)new PropertiesBasedValueSource(this.model.getProperties()), SYNONYM_PREFIXES, true));
        interpolator.addValueSource((ValueSource)new MapBasedValueSource(properties));
        String result = interpolator.interpolate(value, (RecursionInterceptor)new PrefixAwareRecursionInterceptor(SYNONYM_PREFIXES, true));
        Matcher matcher = Pattern.compile(Pattern.quote(PREFIX) + ".*?" + Pattern.quote(POSTFIX)).matcher(result);
        IgnoreWarnFail.checkIgnoreWarnFailState(!matcher.find(), onMissingField, () -> String.format("template %s evaluated to %s", value, result), () -> String.format("could not evaluate %s! (result is %s)", value, result));
        return matcher.replaceAll("");
    }
}

