/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.propertyhelper;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;

public final class TransformerRegistry {
    public static final TransformerRegistry INSTANCE = new TransformerRegistry();
    private final Map<String, Function<String, String>> registry;

    private TransformerRegistry() {
        ImmutableMap.Builder registry = ImmutableMap.builder();
        registry.put((Object)"lowercase", (Object)new LowercaseTransformer());
        registry.put((Object)"uppercase", (Object)new UppercaseTransformer());
        registry.put((Object)"remove_whitespace", (Object)new RemoveWhitespaceTransformer());
        registry.put((Object)"underscore_for_whitespace", (Object)new UnderscoreForWhitespaceTransformer());
        registry.put((Object)"dash_for_whitespace", (Object)new DashForWhitespaceTransformer());
        registry.put((Object)"use_underscore", (Object)new UseUnderscoreTransformer());
        registry.put((Object)"use_dash", (Object)new UseDashTransformer());
        registry.put((Object)"trim", (Object)new TrimTransformer());
        this.registry = registry.build();
    }

    public Function<String, String> applyTransformers(List<String> transformerNames) {
        return value -> this.applyTransformers(transformerNames, (String)value);
    }

    private String applyTransformers(List<String> transformerNames, String value) {
        String res = value;
        ImmutableList transformers = (ImmutableList)transformerNames.stream().map(this::forName).collect(ImmutableList.toImmutableList());
        for (Function transformer : transformers) {
            if (res == null) continue;
            res = (String)transformer.apply(res);
        }
        return res;
    }

    Function<String, String> forName(String transformerName) {
        Preconditions.checkNotNull((Object)transformerName, (Object)"transformerName is null");
        Function<String, String> transformer = this.registry.get(transformerName.toLowerCase(Locale.getDefault()));
        Preconditions.checkState((transformer != null ? 1 : 0) != 0, (String)"Transformer '%s' is unknown.", (Object)transformerName);
        return transformer;
    }

    public static class LowercaseTransformer
    implements Function<String, String> {
        @Override
        public String apply(String value) {
            return value.toLowerCase(Locale.getDefault());
        }
    }

    public static class UppercaseTransformer
    implements Function<String, String> {
        @Override
        public String apply(String value) {
            return value.toUpperCase(Locale.getDefault());
        }
    }

    public static class RemoveWhitespaceTransformer
    implements Function<String, String> {
        @Override
        public String apply(String value) {
            return CharMatcher.whitespace().removeFrom((CharSequence)value);
        }
    }

    public static class UnderscoreForWhitespaceTransformer
    implements Function<String, String> {
        @Override
        public String apply(String value) {
            return CharMatcher.whitespace().collapseFrom((CharSequence)value, '_');
        }
    }

    public static class DashForWhitespaceTransformer
    implements Function<String, String> {
        @Override
        public String apply(String value) {
            return CharMatcher.whitespace().collapseFrom((CharSequence)value, '-');
        }
    }

    public static class UseUnderscoreTransformer
    implements Function<String, String> {
        @Override
        public String apply(String value) {
            return CharMatcher.whitespace().or(CharMatcher.anyOf((CharSequence)"-_")).collapseFrom((CharSequence)value, '_');
        }
    }

    public static class UseDashTransformer
    implements Function<String, String> {
        @Override
        public String apply(String value) {
            return CharMatcher.whitespace().or(CharMatcher.anyOf((CharSequence)"-_")).collapseFrom((CharSequence)value, '-');
        }
    }

    public static class TrimTransformer
    implements Function<String, String> {
        @Override
        public String apply(String value) {
            return CharMatcher.whitespace().trimFrom((CharSequence)value);
        }
    }
}

