/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.propertyhelper.definitions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.basepom.mojo.propertyhelper.FieldContext;
import org.basepom.mojo.propertyhelper.IgnoreWarnFail;
import org.basepom.mojo.propertyhelper.ValueCache;
import org.basepom.mojo.propertyhelper.ValueProvider;
import org.basepom.mojo.propertyhelper.definitions.FieldDefinition;
import org.basepom.mojo.propertyhelper.fields.StringField;

public class StringDefinition
extends FieldDefinition<String> {
    private List<String> values = ImmutableList.of();
    boolean blankIsValid = true;
    private IgnoreWarnFail onMissingValue = IgnoreWarnFail.FAIL;

    public void setValues(List<String> values) {
        Preconditions.checkNotNull(values, (Object)"values is null");
        this.values = (List)values.stream().map(v -> Objects.requireNonNullElse(v, "")).collect(ImmutableList.toImmutableList());
    }

    public void setOnMissingValue(String onMissingValue) {
        this.onMissingValue = IgnoreWarnFail.forString(onMissingValue);
    }

    public StringDefinition() {
    }

    @VisibleForTesting
    StringDefinition(String id) {
        super(id);
    }

    public List<String> getValues() {
        return this.values;
    }

    public boolean isBlankIsValid() {
        return this.blankIsValid;
    }

    public IgnoreWarnFail getOnMissingValue() {
        return this.onMissingValue;
    }

    @Override
    public StringField createField(FieldContext context, ValueCache valueCache) throws IOException {
        Preconditions.checkNotNull((Object)context, (Object)"context is null");
        Preconditions.checkNotNull((Object)valueCache, (Object)"valueCache is null");
        this.check();
        ValueProvider stringValue = valueCache.getValueProvider(this);
        return new StringField(this, stringValue, context);
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", StringDefinition.class.getSimpleName() + "[", "]").add("values=" + this.values).add("blankIsValid=" + this.blankIsValid).add("onMissingValue=" + this.onMissingValue).add(super.toString()).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StringDefinition that = (StringDefinition)o;
        return this.blankIsValid == that.blankIsValid && Objects.equals(this.values, that.values) && this.onMissingValue == that.onMissingValue;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.values, this.blankIsValid, this.onMissingValue});
    }
}

