/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.propertyhelper.fields;

import com.google.common.annotations.VisibleForTesting;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.StringJoiner;
import org.basepom.mojo.propertyhelper.Field;
import org.basepom.mojo.propertyhelper.FieldContext;
import org.basepom.mojo.propertyhelper.ValueProvider;
import org.basepom.mojo.propertyhelper.definitions.DateDefinition;

public final class DateField
extends Field<ZonedDateTime, DateDefinition> {
    private final ValueProvider valueProvider;
    private final ZoneId timezone;

    @VisibleForTesting
    public static DateField forTesting(DateDefinition dateDefinition, ValueProvider valueProvider) {
        return new DateField(dateDefinition, valueProvider, FieldContext.forTesting());
    }

    public DateField(DateDefinition dateDefinition, ValueProvider valueProvider, FieldContext fieldContext) {
        super(dateDefinition, fieldContext);
        this.valueProvider = valueProvider;
        this.timezone = dateDefinition.getTimezone();
    }

    @Override
    public String getFieldName() {
        return ((DateDefinition)this.fieldDefinition).getId();
    }

    @Override
    public String getValue() {
        ZonedDateTime date = this.valueProvider.getValue().map(value -> ((DateDefinition)this.fieldDefinition).getParser().apply((String)value)).orElseGet(() -> ((DateDefinition)this.fieldDefinition).getValue().map(((DateDefinition)this.fieldDefinition).getLongParser()).orElseGet(this::now));
        String result = this.formatResult(date);
        if (((DateDefinition)this.fieldDefinition).getFormatter().isPresent()) {
            this.valueProvider.setValue(result);
        } else {
            this.valueProvider.setValue(Long.toString(date.toInstant().toEpochMilli()));
        }
        return result;
    }

    @Override
    public boolean isExposeAsProperty() {
        return ((DateDefinition)this.fieldDefinition).isExport();
    }

    private ZonedDateTime now() {
        return ZonedDateTime.now(this.timezone).truncatedTo(ChronoUnit.MILLIS);
    }

    public String toString() {
        return new StringJoiner(", ", DateField.class.getSimpleName() + "[", "]").add("valueProvider=" + this.valueProvider).toString();
    }
}

