/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.propertyhelper.groups;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.basepom.mojo.propertyhelper.FieldContext;
import org.basepom.mojo.propertyhelper.IgnoreWarnFail;
import org.basepom.mojo.propertyhelper.definitions.PropertyDefinition;
import org.basepom.mojo.propertyhelper.definitions.PropertyGroupDefinition;
import org.basepom.mojo.propertyhelper.groups.PropertyResult;

public class PropertyGroup {
    private final PropertyGroupDefinition propertyGroupDefinition;
    private final FieldContext context;

    public PropertyGroup(PropertyGroupDefinition propertyGroupDefinition, FieldContext context) {
        this.propertyGroupDefinition = propertyGroupDefinition;
        this.context = context;
    }

    public String getId() {
        return this.propertyGroupDefinition.getId();
    }

    public boolean checkActive(boolean isSnapshot) {
        return this.propertyGroupDefinition.isActiveOnRelease() && !isSnapshot || this.propertyGroupDefinition.isActiveOnSnapshot() && isSnapshot;
    }

    public IgnoreWarnFail getOnDuplicateProperty() {
        return this.propertyGroupDefinition.getOnDuplicateProperty();
    }

    public String getPropertyValue(PropertyDefinition propertyDefinition, Map<String, String> propElements) {
        return Optional.ofNullable(propertyDefinition.getValue()).map(this.context.getInterpolatorFactory().interpolate(propertyDefinition.getName(), this.propertyGroupDefinition.getOnMissingField(), propElements)).map(this.context.getTransformerRegistry().applyTransformers(propertyDefinition.getTransformers())).orElse("");
    }

    public Set<PropertyResult> createProperties(Map<String, String> values) {
        return (Set)this.propertyGroupDefinition.getPropertyDefinitions().stream().map(propertyDefinition -> new PropertyResult(propertyDefinition.getName(), this.getPropertyValue((PropertyDefinition)propertyDefinition, values))).collect(ImmutableSet.toImmutableSet());
    }
}

