/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.repack;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.shared.artifact.filter.collection.AbstractArtifactsFilter;
import org.basepom.mojo.repack.DependencyDefinition;
import org.basepom.mojo.repack.Reporter;

final class DependencyDefinitionFilter
extends AbstractArtifactsFilter {
    private final Set<DependencyDefinition> dependencies;
    private final boolean include;

    DependencyDefinitionFilter(Set<DependencyDefinition> dependencies, boolean include) {
        this.dependencies = (Set)Preconditions.checkNotNull(dependencies, (Object)"dependencies is null");
        this.include = include;
    }

    public Set<Artifact> filter(Set<Artifact> artifacts) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        block0: for (Artifact artifact : artifacts) {
            for (DependencyDefinition dependency : this.dependencies) {
                if (this.include == dependency.matches(artifact)) {
                    builder.add((Object)artifact);
                    continue block0;
                }
                Reporter.addExcluded(artifact, this.include ? "included" : "excluded");
            }
        }
        return builder.build();
    }
}

