/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.repack;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckForNull;
import org.apache.maven.artifact.Artifact;
import org.basepom.mojo.repack.Wildcard;

final class DependencyDefinition {
    private final String artifactId;
    private final String groupId;
    private final String type;
    @CheckForNull
    private final String classifier;

    DependencyDefinition(String value) {
        String classifier;
        Preconditions.checkNotNull((Object)value, (Object)"value is null");
        List elements = Splitter.on((char)':').trimResults().splitToList((CharSequence)value);
        Preconditions.checkState((!elements.isEmpty() ? 1 : 0) != 0, (Object)"Dependency reference requires at least a group id!");
        String groupId = (String)elements.get(0);
        this.groupId = groupId.isEmpty() ? "*" : groupId;
        this.artifactId = elements.size() > 1 && !((String)elements.get(1)).isEmpty() ? (String)elements.get(1) : "*";
        String type = elements.size() > 2 && !((String)elements.get(2)).isEmpty() ? (String)elements.get(2) : "jar";
        String string = classifier = elements.size() > 3 && !((String)elements.get(3)).isEmpty() ? (String)elements.get(3) : null;
        if ("test-jar".equals(type)) {
            this.type = "jar";
            this.classifier = (String)MoreObjects.firstNonNull((Object)classifier, (Object)"tests");
        } else {
            this.type = type;
            this.classifier = classifier;
        }
    }

    DependencyDefinition(Artifact artifact) {
        Preconditions.checkNotNull((Object)artifact, (Object)"artifact is null");
        this.artifactId = (String)Preconditions.checkNotNull((Object)artifact.getArtifactId(), (String)"artifactId for artifact '%s' is null", (Object)artifact);
        this.groupId = (String)Preconditions.checkNotNull((Object)artifact.getGroupId(), (String)"groupId for artifact '%s' is null", (Object)artifact);
        String type = artifact.getType();
        String classifier = artifact.getClassifier();
        if ("test-jar".equals(type)) {
            this.classifier = (String)MoreObjects.firstNonNull((Object)classifier, (Object)"tests");
            this.type = "jar";
        } else {
            this.type = (String)MoreObjects.firstNonNull((Object)type, (Object)"jar");
            this.classifier = classifier;
        }
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getType() {
        return this.type;
    }

    public Optional<String> getClassifier() {
        return Optional.ofNullable(this.classifier);
    }

    public boolean matches(Artifact artifact) {
        return this.matches(new DependencyDefinition(artifact));
    }

    public boolean matches(DependencyDefinition other) {
        if (!Wildcard.wildcardMatch(this.getGroupId(), other.getGroupId())) {
            return false;
        }
        if (!Wildcard.wildcardMatch(this.getArtifactId(), other.getArtifactId())) {
            return false;
        }
        if (!Objects.equals(this.getType(), other.getType())) {
            return false;
        }
        return this.getClassifier().map(cl -> Objects.equals(cl, other.getClassifier().orElse(null))).orElse(true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DependencyDefinition that = (DependencyDefinition)o;
        return this.artifactId.equals(that.artifactId) && this.groupId.equals(that.groupId) && this.type.equals(that.type) && Objects.equals(this.classifier, that.classifier);
    }

    public int hashCode() {
        return Objects.hash(this.artifactId, this.groupId, this.type, this.classifier);
    }

    public String toString() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)this.getGroupId());
        builder.add((Object)this.getArtifactId());
        builder.add((Object)this.getType());
        builder.add((Object)this.getClassifier().orElse("<any>"));
        return Joiner.on((char)':').join((Iterable)builder.build());
    }
}

