/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.repack;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.shared.artifact.filter.collection.AbstractArtifactsFilter;
import org.basepom.mojo.repack.DependencyDefinition;
import org.basepom.mojo.repack.Reporter;

final class OptionalArtifactFilter
extends AbstractArtifactsFilter {
    private final Set<DependencyDefinition> includeDependencies;

    OptionalArtifactFilter(Set<DependencyDefinition> includedDependencies) {
        this.includeDependencies = (Set)Preconditions.checkNotNull(includedDependencies, (Object)"includedDependencies is null");
    }

    public Set<Artifact> filter(Set<Artifact> artifacts) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        block0: for (Artifact artifact : artifacts) {
            if (!artifact.isOptional()) {
                builder.add((Object)artifact);
                continue;
            }
            for (DependencyDefinition includedDependency : this.includeDependencies) {
                if (!includedDependency.matches(artifact)) continue;
                builder.add((Object)artifact);
                Reporter.addOptional(artifact);
                continue block0;
            }
            Reporter.addExcluded(artifact, "optional");
        }
        return builder.build();
    }
}

