/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.repack;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.nio.file.attribute.FileTime;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.artifact.filter.collection.ArtifactFilterException;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.apache.maven.shared.artifact.filter.collection.FilterArtifacts;
import org.basepom.mojo.repack.ArtifactsLibraries;
import org.basepom.mojo.repack.DependencyDefinition;
import org.basepom.mojo.repack.DependencyDefinitionFilter;
import org.basepom.mojo.repack.LayoutType;
import org.basepom.mojo.repack.OptionalArtifactFilter;
import org.basepom.mojo.repack.PluginLog;
import org.basepom.mojo.repack.Reporter;
import org.basepom.mojo.repack.ScopeExclusionFilter;
import org.springframework.boot.loader.tools.Layers;
import org.springframework.boot.loader.tools.LayoutFactory;
import org.springframework.boot.loader.tools.Libraries;
import org.springframework.boot.loader.tools.Repackager;

@Mojo(name="repack", defaultPhase=LifecyclePhase.PACKAGE, requiresProject=true, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public final class RepackMojo
extends AbstractMojo {
    private static final Pattern WHITE_SPACE_PATTERN = Pattern.compile("\\s+");
    private static final PluginLog LOG = new PluginLog(RepackMojo.class);
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    MavenSession session;
    @Component
    MavenProjectHelper projectHelper;
    @Parameter(property="repack.main-class")
    String mainClass = null;
    private Set<DependencyDefinition> includedDependencies = ImmutableSet.of();
    private Set<DependencyDefinition> excludedDependencies = ImmutableSet.of();
    @Parameter(defaultValue="false", property="repack.include-system-scope")
    boolean includeSystemScope = false;
    @Parameter(defaultValue="false", property="repack.include-provided-scope")
    boolean includeProvidedScope = false;
    @Parameter(defaultValue="false", property="repack.include-optional")
    boolean includeOptional = false;
    @Parameter(defaultValue="${project.build.directory}", property="repack.output-directory")
    File outputDirectory;
    @Parameter(defaultValue="${project.build.finalName}", property="repack.final-name")
    String finalName;
    @Parameter(defaultValue="false", property="repack.skip")
    boolean skip = false;
    @Parameter(defaultValue="false", property="repack.quiet")
    boolean quiet = false;
    @Parameter(defaultValue="true", property="repack.report")
    boolean report = true;
    @Parameter(defaultValue="repacked", property="repack.classifier")
    String repackClassifier = "repacked";
    @Parameter(defaultValue="true", property="repack.attach-artifact")
    boolean attachRepackedArtifact = true;
    private Set<DependencyDefinition> runtimeUnpackedDependencies = ImmutableSet.of();
    private Set<DependencyDefinition> optionalDependencies = ImmutableSet.of();
    @Parameter(defaultValue="${project.build.outputTimestamp}", property="repack.output-timestamp")
    String outputTimestamp;
    @Parameter(defaultValue="JAR", property="repack.layout")
    LayoutType layout = LayoutType.JAR;
    @Parameter
    LayoutFactory layoutFactory = null;

    @Parameter(alias="includes")
    public void setIncludedDependencies(String ... includedDependencies) {
        Preconditions.checkNotNull((Object)includedDependencies, (Object)"includedDependencies is null");
        this.includedDependencies = (Set)Arrays.stream(includedDependencies).map(DependencyDefinition::new).collect(ImmutableSet.toImmutableSet());
    }

    @Parameter(alias="excludedDependencies")
    public void setExcludedDependencies(String ... excludedDependencies) {
        Preconditions.checkNotNull((Object)excludedDependencies, (Object)"excludedDependencies is null");
        this.excludedDependencies = (Set)Arrays.stream(excludedDependencies).map(DependencyDefinition::new).collect(ImmutableSet.toImmutableSet());
    }

    @Parameter
    public void setRuntimeUnpackedDependencies(String ... runtimeUnpackedDependencies) {
        Preconditions.checkNotNull((Object)runtimeUnpackedDependencies, (Object)"runtimeUnpackDependencies is null");
        this.runtimeUnpackedDependencies = (Set)Arrays.stream(runtimeUnpackedDependencies).map(DependencyDefinition::new).collect(ImmutableSet.toImmutableSet());
    }

    @Parameter
    public void setOptionalDependencies(String ... optionalDependencies) {
        Preconditions.checkNotNull((Object)optionalDependencies, (Object)"optionalDependencies is null");
        this.optionalDependencies = (Set)Arrays.stream(optionalDependencies).map(DependencyDefinition::new).collect(ImmutableSet.toImmutableSet());
    }

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            LOG.report(this.quiet, "Skipping plugin execution", new Object[0]);
            return;
        }
        if ("pom".equals(this.project.getPackaging())) {
            LOG.report(this.quiet, "Ignoring POM project", new Object[0]);
            return;
        }
        Preconditions.checkState((this.outputDirectory != null ? 1 : 0) != 0, (Object)"output directory was unset!");
        Preconditions.checkState((boolean)this.outputDirectory.exists(), (String)"output directory '%s' does not exist!", (Object)this.outputDirectory.getAbsolutePath());
        if (Strings.nullToEmpty((String)this.finalName).isBlank()) {
            this.finalName = this.project.getArtifactId() + "-" + this.project.getVersion();
            LOG.report(this.quiet, "Final name unset, falling back to %s", this.finalName);
        }
        if (Strings.nullToEmpty((String)this.repackClassifier).isBlank()) {
            if (Strings.nullToEmpty((String)this.project.getArtifact().getClassifier()).isBlank()) {
                LOG.report(this.quiet, "Repacked archive will replace main artifact", new Object[0]);
            } else {
                LOG.report(this.quiet, "Repacked archive will have no classifier, main artifact has classifier '%s'", this.project.getArtifact().getClassifier());
            }
        } else if (this.repackClassifier.equals(this.project.getArtifact().getClassifier())) {
            LOG.report(this.quiet, "Repacked archive will replace main artifact using classifier '%s'", this.repackClassifier);
        } else {
            LOG.report(this.quiet, "Repacked archive will use classifier '%s', main artifact has %s", this.repackClassifier, this.project.getArtifact().getClassifier() == null ? "no classifier" : "classifier '" + this.project.getArtifact().getClassifier() + "'");
        }
        try {
            Artifact source = this.project.getArtifact();
            Repackager repackager = new Repackager(source.getFile());
            if (this.mainClass != null && !this.mainClass.isEmpty()) {
                repackager.setMainClass(this.mainClass);
            } else {
                repackager.addMainClassTimeoutWarningListener((duration, mainMethod) -> LOG.warn("Searching for the main class is taking some time, consider using the mainClass configuration parameter.", new Object[0]));
            }
            if (this.layoutFactory != null) {
                LOG.report(this.quiet, "Using %s Layout Factory to repack the %s artifact.", this.layoutFactory.getClass().getSimpleName(), this.project.getArtifact());
                repackager.setLayoutFactory(this.layoutFactory);
            } else if (this.layout != null) {
                LOG.report(this.quiet, "Using %s Layout to repack the %s artifact.", new Object[]{this.layout, this.project.getArtifact()});
                repackager.setLayout(this.layout.layout());
            } else {
                LOG.warn("Neither Layout Factory nor Layout defined, resulting archive may be non-functional.", new Object[0]);
            }
            repackager.setLayers(Layers.IMPLICIT);
            repackager.setIncludeRelevantJarModeJars(false);
            File targetFile = this.getTargetFile();
            Libraries libraries = this.getLibraries();
            FileTime outputFileTimestamp = this.parseOutputTimestamp();
            repackager.repackage(targetFile, libraries, null, outputFileTimestamp);
            boolean repackReplacesSource = source.getFile().equals(targetFile);
            if (this.attachRepackedArtifact) {
                if (repackReplacesSource) {
                    source.setFile(targetFile);
                } else {
                    this.projectHelper.attachArtifact(this.project, this.project.getPackaging(), Strings.emptyToNull((String)this.repackClassifier), targetFile);
                }
            } else if (repackReplacesSource && repackager.getBackupFile().exists()) {
                source.setFile(repackager.getBackupFile());
            } else if (!this.repackClassifier.isEmpty()) {
                LOG.report(this.quiet, "Created repacked archive %s with classifier %s!", targetFile, this.repackClassifier);
            }
            if (this.report) {
                Reporter.report(this.quiet, source, this.repackClassifier);
            }
        }
        catch (IOException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
    }

    private File getTargetFile() {
        StringBuilder targetFileName = new StringBuilder();
        targetFileName.append(this.finalName);
        if (!this.repackClassifier.isEmpty()) {
            targetFileName.append('-').append(this.repackClassifier);
        }
        targetFileName.append('.').append(this.project.getArtifact().getArtifactHandler().getExtension());
        return new File(this.outputDirectory, targetFileName.toString());
    }

    private Libraries getLibraries() throws MojoExecutionException {
        try {
            ImmutableSet artifacts = ImmutableSet.copyOf((Collection)this.project.getArtifacts());
            ImmutableSet includedArtifacts = ImmutableSet.copyOf((Collection)this.buildFilters().filter((Set)artifacts));
            return new ArtifactsLibraries(this.quiet, (Set<Artifact>)artifacts, (Set<Artifact>)includedArtifacts, this.session.getProjects(), this.runtimeUnpackedDependencies);
        }
        catch (ArtifactFilterException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)((Object)ex));
        }
    }

    private FilterArtifacts buildFilters() {
        FilterArtifacts filters = new FilterArtifacts();
        if (!this.includeSystemScope) {
            filters.addFilter((ArtifactsFilter)new ScopeExclusionFilter("system"));
        }
        if (!this.includeProvidedScope) {
            filters.addFilter((ArtifactsFilter)new ScopeExclusionFilter("provided"));
        }
        if (!this.includeOptional) {
            filters.addFilter((ArtifactsFilter)new OptionalArtifactFilter(this.optionalDependencies));
        }
        if (!this.includedDependencies.isEmpty()) {
            filters.addFilter((ArtifactsFilter)new DependencyDefinitionFilter(this.includedDependencies, true));
        }
        if (!this.excludedDependencies.isEmpty()) {
            filters.addFilter((ArtifactsFilter)new DependencyDefinitionFilter(this.excludedDependencies, false));
        }
        return filters;
    }

    private FileTime parseOutputTimestamp() {
        long timestamp;
        if (this.outputTimestamp == null || this.outputTimestamp.length() < 2) {
            return null;
        }
        try {
            timestamp = Long.parseLong(this.outputTimestamp);
        }
        catch (NumberFormatException ex) {
            timestamp = OffsetDateTime.parse(this.outputTimestamp).toInstant().getEpochSecond();
        }
        return FileTime.from(timestamp, TimeUnit.SECONDS);
    }
}

