/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.repack;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSortedMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.function.BiConsumer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.shared.utils.logging.MessageBuilder;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.basepom.mojo.repack.PluginLog;

final class Reporter {
    private static final PluginLog LOG = new PluginLog(Reporter.class);
    private static final Set<Artifact> runtimeUnpackedArtifacts = new HashSet<Artifact>();
    private static final Set<Artifact> optionalArtifacts = new HashSet<Artifact>();
    private static final Map<Artifact, String> excludedArtifacts = new HashMap<Artifact, String>();
    private static final Set<Artifact> includedArtifacts = new HashSet<Artifact>();

    Reporter() {
    }

    static void addRuntimeUnpacked(Artifact artifact) {
        runtimeUnpackedArtifacts.add(artifact);
    }

    static void addOptional(Artifact artifact) {
        optionalArtifacts.add(artifact);
    }

    static void addExcluded(Artifact artifact, String reason) {
        excludedArtifacts.put(artifact, reason);
    }

    static void addIncluded(Artifact artifact) {
        includedArtifacts.add(artifact);
    }

    public static void report(boolean quiet, Artifact source, String classifier) {
        LOG.report(quiet, "", new Object[0]);
        Reporter.header(quiet, String.format(Locale.ROOT, "Summary Report for: %s:%s (%s)", source.getGroupId(), source.getArtifactId(), classifier));
        LOG.report(quiet, "", new Object[0]);
        Reporter.header(quiet, "Included dependencies (" + includedArtifacts.size() + ")");
        Reporter.logReport(quiet, includedArtifacts, (messageBuilder, artifact) -> messageBuilder.strong((Object)artifact.getScope()));
        Reporter.header(quiet, "Included optional dependencies (" + optionalArtifacts.size() + ")");
        Reporter.logReport(quiet, optionalArtifacts, null);
        Reporter.header(quiet, "Excluded dependencies (" + excludedArtifacts.size() + ")");
        Reporter.logReport(quiet, excludedArtifacts.keySet(), (messageBuilder, artifact) -> messageBuilder.strong((Object)excludedArtifacts.get(artifact)));
        Reporter.header(quiet, "Runtime unpacked dependencies (" + runtimeUnpackedArtifacts.size() + ")");
        Reporter.logReport(quiet, runtimeUnpackedArtifacts, null);
    }

    private static void header(boolean quiet, String value) {
        LOG.report(quiet, value, new Object[0]);
        LOG.report(quiet, Strings.repeat((String)"=", (int)value.length()), new Object[0]);
    }

    private static void logReport(boolean quiet, Set<Artifact> artifacts, BiConsumer<MessageBuilder, Artifact> consumer) {
        if (!artifacts.isEmpty()) {
            SortedMap<String, Artifact> names = Reporter.computeNames(artifacts);
            int namePadding = names.keySet().stream().map(String::length).reduce(0, Math::max);
            for (Map.Entry<String, Artifact> entry : names.entrySet()) {
                MessageBuilder mb = MessageUtils.buffer();
                if (consumer == null) {
                    mb.a((CharSequence)entry.getKey());
                } else {
                    mb.a((CharSequence)Strings.padEnd((String)(entry.getKey() + ":"), (int)(namePadding + 2), (char)' '));
                    consumer.accept(mb, entry.getValue());
                }
                LOG.report(quiet, "%s", mb);
            }
        }
        LOG.report(quiet, "", new Object[0]);
    }

    private static SortedMap<String, Artifact> computeNames(Set<Artifact> artifacts) {
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        artifacts.forEach(a -> builder.put((Object)Reporter.computeArtifactName(a), a));
        return builder.build();
    }

    private static String computeArtifactName(Artifact artifact) {
        if (artifact.hasClassifier()) {
            return artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getClassifier();
        }
        return artifact.getGroupId() + ":" + artifact.getArtifactId();
    }
}

