/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.repack;

import com.google.common.base.Preconditions;

final class Wildcard {
    private Wildcard() {
        throw new AssertionError((Object)"Wildcard can not be instantiated");
    }

    static boolean wildcardMatch(String pattern, String value) {
        Preconditions.checkNotNull((Object)pattern, (Object)"pattern is null");
        Preconditions.checkNotNull((Object)value, (Object)"value is null");
        if (pattern.isEmpty()) {
            return value.isEmpty();
        }
        if (pattern.equals("*")) {
            return true;
        }
        if (value.isEmpty()) {
            return false;
        }
        return Wildcard.doGlobMatch(pattern, value);
    }

    static boolean doGlobMatch(String pattern, String value) {
        int valueIndex = 0;
        int patternLength = pattern.length();
        int valueLength = value.length();
        for (int patternIndex = 0; patternIndex < patternLength; ++patternIndex) {
            char patternChar = pattern.charAt(patternIndex);
            if (valueIndex == valueLength && patternChar != '*') {
                return false;
            }
            switch (patternChar) {
                case '*': {
                    do {
                        if (patternIndex + 1 != patternLength) continue;
                        return true;
                    } while (pattern.charAt(++patternIndex) == '*');
                    while (valueIndex < valueLength) {
                        boolean matched = Wildcard.doGlobMatch(value.substring(valueIndex), pattern.substring(patternIndex));
                        if (matched) {
                            return true;
                        }
                        ++valueIndex;
                    }
                    return false;
                }
                case '?': {
                    break;
                }
                default: {
                    if (value.charAt(valueIndex) == patternChar) break;
                    return false;
                }
            }
            ++valueIndex;
        }
        return valueIndex == valueLength;
    }
}

