/*
 * Decompiled with CFR 0.152.
 */
package org.basex;

import java.io.IOException;
import java.io.InputStream;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.servlet.ServletContext;
import org.basex.core.BaseXException;
import org.basex.core.CLI;
import org.basex.core.StaticOptions;
import org.basex.core.Text;
import org.basex.http.HTTPContext;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.io.IOStream;
import org.basex.server.Log;
import org.basex.util.Main;
import org.basex.util.MainParser;
import org.basex.util.Performance;
import org.basex.util.Prop;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.options.Option;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.util.resource.PathResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.xml.XmlConfiguration;

public final class BaseXHTTP
extends CLI {
    private final StaticOptions soptions = new StaticOptions(true);
    private final HTTPContext hc;
    private final Server jetty;
    private boolean service;
    private boolean quiet;
    private String password;
    private boolean stop;
    private int port;

    public static void main(String ... args) {
        try {
            new BaseXHTTP(args);
        }
        catch (Exception ex) {
            Util.errln((Object)ex, (Object[])new Object[0]);
            System.exit(1);
        }
    }

    public BaseXHTTP(String ... args) throws Exception {
        super(null, args);
        int stopPort;
        if (!this.quiet) {
            Util.outln((Object)this.header(), (Object[])new Object[0]);
        }
        this.hc = HTTPContext.get();
        this.hc.init(this.soptions);
        String webapp = this.soptions.get(StaticOptions.WEBPATH);
        WebAppContext wac = new WebAppContext(webapp, "/");
        BaseXHTTP.locate("WEB-INF/web.xml", webapp);
        IOFile url = BaseXHTTP.locate("WEB-INF/jetty.xml", webapp);
        this.jetty = (Server)new XmlConfiguration((Resource)new PathResource(url.file())).configure();
        if (this.soptions.get(StaticOptions.GZIP).booleanValue()) {
            GzipHandler gzip = new GzipHandler();
            gzip.addIncludedMethods(new String[]{HttpMethod.POST.asString(), HttpMethod.PUT.asString()});
            gzip.setInflateBufferSize(1024);
            gzip.setHandler((Handler)wac);
            this.jetty.setHandler((Handler)gzip);
        } else {
            this.jetty.setHandler((Handler)wac);
        }
        ServerConnector sc = null;
        for (Connector conn : this.jetty.getConnectors()) {
            if (!(conn instanceof ServerConnector)) continue;
            sc = (ServerConnector)conn;
        }
        if (sc == null) {
            throw new BaseXException("No Jetty connector defined in WEB-INF/jetty.xml.", new Object[0]);
        }
        if (this.port != 0) {
            sc.setPort(this.port);
        } else {
            this.port = sc.getPort();
        }
        Function<Boolean, String> msg1 = start -> start != false ? Text.SRV_STARTED_PORT_X : Text.SRV_STOPPED_PORT_X;
        Function<Boolean, String> msg2 = start -> Util.info((Object)("HTTP " + (String)msg1.apply((Boolean)start)), (Object[])new Object[]{this.port});
        Consumer<Boolean> info = start -> {
            Util.outln(msg2.apply((Boolean)start), (Object[])new Object[0]);
            if (!this.soptions.get(StaticOptions.HTTPLOCAL).booleanValue()) {
                int serverPort = this.soptions.get(StaticOptions.SERVERPORT);
                Util.outln(msg1.apply((Boolean)start), (Object[])new Object[]{serverPort});
            }
            Performance.sleep((long)1000L);
        };
        if (this.stop) {
            this.stop();
            if (!this.quiet) {
                info.accept(false);
            }
            return;
        }
        if (this.service) {
            BaseXHTTP.start(args);
            if (!this.quiet) {
                info.accept(true);
            }
            return;
        }
        try {
            this.jetty.start();
        }
        catch (BindException ex) {
            Util.debug((Throwable)ex);
            throw new BaseXException("HTTP " + Text.SRV_RUNNING_X, new Object[]{this.port});
        }
        IOException ex = this.hc.exception();
        if (ex != null) {
            throw ex;
        }
        this.context = this.hc.init((ServletContext)wac.getServletContext());
        if (this.password != null) {
            this.context.user().password(this.password);
        }
        if ((stopPort = this.soptions.get(StaticOptions.STOPPORT).intValue()) > 0) {
            new StopServer(stopPort).start();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            String message = (String)msg2.apply(false);
            if (!this.quiet) {
                Util.outln((Object)message, (Object[])new Object[0]);
            }
            this.context.log.writeServer(Log.LogType.OK, message);
            this.context.close();
        }));
        if (!this.quiet) {
            Util.outln((Object)msg2.apply(true), (Object[])new Object[0]);
        }
        this.context.log.writeServer(Log.LogType.OK, msg2.apply(true));
        for (Map.Entry cmd : this.commands) {
            if (this.execute(cmd)) continue;
            return;
        }
    }

    public void stop() throws IOException {
        String host = this.soptions.get(StaticOptions.SERVERHOST);
        int stopPort = this.soptions.get(StaticOptions.STOPPORT);
        if (stopPort > 0) {
            BaseXHTTP.stop(host.isEmpty() ? "localhost" : host, stopPort);
        }
    }

    private static IOFile locate(String file, String root) throws IOException {
        byte[] data;
        IOFile target = new IOFile(root, file);
        boolean create = !target.exists();
        IOFile io = new IOFile("src/main/webapp", file);
        if (io.exists()) {
            data = io.read();
            IOFile dir = new IOFile("src/main/resources");
            if (!(!dir.exists() || (dir = new IOFile(dir, file)).exists() && Token.eq((byte[])data, (byte[])dir.read()))) {
                Util.errln((Object)("Updating " + dir), (Object[])new Object[0]);
                dir.parent().md();
                dir.write(data);
            }
        } else if (create) {
            try (InputStream is = BaseXHTTP.class.getResourceAsStream("/" + file);){
                if (is == null) {
                    throw new BaseXException((IO)io + " not found.", new Object[0]);
                }
                data = new IOStream(is).read();
            }
        } else {
            return target;
        }
        if (create) {
            Util.errln((Object)("Creating " + target), (Object[])new Object[0]);
            target.parent().md();
            target.write(data);
        }
        return target;
    }

    protected void parseArgs() throws IOException {
        MainParser arg = new MainParser((Main)this);
        boolean daemon = true;
        block16: while (arg.more()) {
            if (arg.dash()) {
                switch (arg.next()) {
                    case 'c': {
                        this.commands.add(BaseXHTTP.input((String)arg.string()));
                        continue block16;
                    }
                    case 'd': {
                        Prop.put((Option)StaticOptions.DEBUG, (String)Boolean.toString(true));
                        Prop.debug = true;
                        continue block16;
                    }
                    case 'D': {
                        daemon = false;
                        continue block16;
                    }
                    case 'g': {
                        Prop.put((Option)StaticOptions.GZIP, (String)Boolean.toString(true));
                        continue block16;
                    }
                    case 'h': {
                        this.port = arg.number();
                        continue block16;
                    }
                    case 'l': {
                        Prop.put((Option)StaticOptions.HTTPLOCAL, (String)Boolean.toString(true));
                        continue block16;
                    }
                    case 'n': {
                        String n = arg.string();
                        Prop.put((Option)StaticOptions.HOST, (String)n);
                        Prop.put((Option)StaticOptions.SERVERHOST, (String)n);
                        continue block16;
                    }
                    case 'p': {
                        int p = arg.number();
                        Prop.put((Option)StaticOptions.PORT, (String)Integer.toString(p));
                        Prop.put((Option)StaticOptions.SERVERPORT, (String)Integer.toString(p));
                        continue block16;
                    }
                    case 'P': {
                        this.password = arg.string();
                        continue block16;
                    }
                    case 'q': {
                        this.quiet = true;
                        continue block16;
                    }
                    case 's': {
                        Prop.put((Option)StaticOptions.STOPPORT, (String)Integer.toString(arg.number()));
                        continue block16;
                    }
                    case 'S': {
                        this.service = daemon;
                        continue block16;
                    }
                    case 'U': {
                        Prop.put((Option)StaticOptions.USER, (String)arg.string());
                        continue block16;
                    }
                    case 'z': {
                        Prop.put((Option)StaticOptions.LOG, (String)Boolean.toString(false));
                        continue block16;
                    }
                }
                throw arg.usage();
            }
            if (!"stop".equalsIgnoreCase(arg.string())) {
                throw arg.usage();
            }
            this.stop = true;
        }
        if (this.service) {
            this.commands.clear();
        }
    }

    public static void start(String ... args) throws BaseXException {
        String error = Util.error((Process)Util.start(BaseXHTTP.class, (String[])args), (int)2000);
        if (error != null) {
            throw new BaseXException(error.trim(), new Object[0]);
        }
    }

    public static void stop(String host, int port) throws IOException {
        IOFile stopFile = BaseXHTTP.stopFile(BaseXHTTP.class, (int)port);
        stopFile.parent().md();
        stopFile.touch();
        try (Socket s = new Socket(host, port);){
            do {
                Performance.sleep((long)10L);
            } while (stopFile.exists());
        }
        catch (IOException ex) {
            Util.debug((Throwable)ex);
            stopFile.delete();
            throw new IOException(Util.info((Object)Text.CONNECTION_ERROR_X, (Object[])new Object[]{port}));
        }
    }

    public String header() {
        return Util.info((Object)Text.S_CONSOLE_X, (Object[])new Object[]{"HTTP Server"});
    }

    public String usage() {
        return Text.S_HTTPINFO;
    }

    private final class StopServer
    extends Thread {
        private final ServerSocket socket;
        private final IOFile stopFile;
        private final int stopPort;

        StopServer(int port) throws IOException {
            this.stopPort = port;
            String host = BaseXHTTP.this.soptions.get(StaticOptions.SERVERHOST);
            InetAddress addr = host.isEmpty() ? null : InetAddress.getByName(host);
            this.socket = new ServerSocket();
            this.socket.setReuseAddress(true);
            this.socket.bind(new InetSocketAddress(addr, this.stopPort));
            this.stopFile = BaseXHTTP.stopFile((Class)BaseXHTTP.class, (int)this.stopPort);
        }

        @Override
        public void run() {
            try {
                do {
                    Util.outln((Object)("HTTP STOP " + Text.SRV_STARTED_PORT_X), (Object[])new Object[]{this.stopPort});
                    Socket s = this.socket.accept();
                    if (s == null) continue;
                    s.close();
                } while (!this.stopFile.exists());
                this.socket.close();
                Util.outln((Object)("HTTP STOP " + Text.SRV_STOPPED_PORT_X), (Object[])new Object[]{this.stopPort});
                BaseXHTTP.this.jetty.stop();
                BaseXHTTP.this.hc.close();
                Prop.clear();
                if (!this.stopFile.delete()) {
                    BaseXHTTP.this.context.log.writeServer(Log.LogType.ERROR, Util.info((Object)Text.FILE_NOT_DELETED_X, (Object[])new Object[]{this.stopFile}));
                }
            }
            catch (Exception ex) {
                Util.stack((Throwable)ex);
            }
        }
    }
}

