/*
 * Decompiled with CFR 0.152.
 */
package org.basex.api.xmldb;

import java.io.IOException;
import java.lang.reflect.Field;
import org.basex.api.xmldb.BXCollectionManagementService;
import org.basex.api.xmldb.BXDatabase;
import org.basex.api.xmldb.BXQueryService;
import org.basex.api.xmldb.BXXMLResource;
import org.basex.build.MemBuilder;
import org.basex.build.Parser;
import org.basex.build.xml.DOMWrapper;
import org.basex.core.BaseXException;
import org.basex.core.Context;
import org.basex.core.MainOptions;
import org.basex.core.cmd.CreateDB;
import org.basex.core.cmd.Open;
import org.basex.data.Data;
import org.basex.data.DataClip;
import org.basex.data.MemData;
import org.basex.data.MetaData;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.util.Strings;
import org.basex.util.Util;
import org.basex.util.list.IntList;
import org.basex.util.list.StringList;
import org.w3c.dom.Document;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.Service;
import org.xmldb.api.base.XMLDBException;

public final class BXCollection
implements Collection {
    final BXDatabase db;
    final Context ctx;
    Data data;

    public BXCollection(String name, boolean open, Database database) throws XMLDBException {
        this.db = (BXDatabase)database;
        this.ctx = this.db.ctx;
        try {
            MainOptions mopts = this.ctx.options;
            this.data = open ? Open.open((String)name, (Context)this.ctx, (MainOptions)mopts, (boolean)true, (boolean)true) : CreateDB.create((String)name, (Parser)Parser.emptyParser((MainOptions)mopts), (Context)this.ctx, (MainOptions)mopts);
        }
        catch (IOException ex) {
            throw new XMLDBException(1, ex.getMessage());
        }
    }

    public String getName() {
        return this.data.meta.name;
    }

    public Service[] getServices() throws XMLDBException {
        this.check();
        return new Service[]{this.getService("XPathQueryService", "1.0"), this.getService("XQueryQueryService", "1.0"), this.getService("CollectionManagementService", "1.0")};
    }

    public Service getService(String name, String version) throws XMLDBException {
        this.check();
        if ("1.0".equals(version)) {
            if (Strings.eq((String)name, (String[])new String[]{"XPathQueryService", "XQueryQueryService"})) {
                return new BXQueryService(this, name, version);
            }
            if (name.equals("CollectionManagementService")) {
                return new BXCollectionManagementService(this);
            }
        }
        return null;
    }

    public Collection getParentCollection() throws XMLDBException {
        this.check();
        return null;
    }

    public Collection getChildCollection(String name) throws XMLDBException {
        this.check();
        return null;
    }

    public int getChildCollectionCount() throws XMLDBException {
        this.check();
        return 0;
    }

    public String[] listChildCollections() throws XMLDBException {
        this.check();
        return new String[0];
    }

    public int getResourceCount() throws XMLDBException {
        this.check();
        return this.data.meta.ndocs;
    }

    public String[] listResources() throws XMLDBException {
        this.check();
        IntList docs = this.data.resources.docs();
        int ds = docs.size();
        StringList sl = new StringList((long)ds);
        for (int d = 0; d < ds; ++d) {
            sl.add(this.data.text(docs.get(d), true));
        }
        return (String[])sl.finish();
    }

    public BXXMLResource createResource(String id, String type) throws XMLDBException {
        this.check();
        if (type.equals("XMLResource")) {
            String uid = id == null || id.isEmpty() ? this.createId() : id;
            return new BXXMLResource(null, 0, uid, this);
        }
        throw type.equals("BinaryResource") ? new XMLDBException(1, "Binary resources not supported.") : new XMLDBException(302, "Resource type is unknown: " + type);
    }

    public void removeResource(Resource resource) throws XMLDBException {
        this.check();
        BXXMLResource del = BXCollection.checkXML(resource);
        if (del.data != this.data && del.data != null) {
            throw new XMLDBException(300, "Unknown Resource: " + this.data.meta.name);
        }
        MainOptions mopts = this.ctx.options;
        try {
            this.data.startUpdate(mopts);
            this.data.delete(this.getResource((String)del.getId()).pre);
            this.data.finishUpdate(mopts);
        }
        catch (BaseXException ex) {
            Util.debug((Throwable)ex);
            throw new XMLDBException(1, "Database cannot be marked as 'updating'.");
        }
    }

    public void storeResource(Resource resource) throws XMLDBException {
        MemData md;
        this.check();
        BXXMLResource xml = BXCollection.checkXML(resource);
        if (resource.getContent() == null) {
            throw new XMLDBException(301, "Resource has no contents.");
        }
        String id = resource.getId();
        if (id == null) {
            throw new XMLDBException(301, "Resource has no ID.");
        }
        BXXMLResource old = this.getResource(id);
        if (old != null) {
            this.removeResource((Resource)old);
        }
        Object cont = xml.content;
        MainOptions mopts = this.ctx.options;
        try {
            DOMWrapper p = cont instanceof Document ? new DOMWrapper((Document)cont, id, mopts) : Parser.singleParser((IO)new IOContent((byte[])cont, id), (MainOptions)mopts, (String)"");
            md = MemBuilder.build((String)id, (Parser)p);
        }
        catch (IOException ex) {
            throw new XMLDBException(301, ex.getMessage());
        }
        try {
            this.data.startUpdate(mopts);
            this.data.insert(this.data.meta.size, -1, new DataClip((Data)md));
            this.data.finishUpdate(mopts);
        }
        catch (BaseXException ex) {
            Util.debug((Throwable)ex);
            throw new XMLDBException(1, "Database cannot be marked as 'updating'.");
        }
    }

    public BXXMLResource getResource(String id) throws XMLDBException {
        this.check();
        if (id == null) {
            return null;
        }
        int pre = this.data.resources.doc(id);
        return pre == -1 ? null : new BXXMLResource(this.data, pre, id, this);
    }

    public String createId() throws XMLDBException {
        String id;
        String[] resources = this.listResources();
        while (BXCollection.contains(resources, id = Long.toString(System.currentTimeMillis()))) {
        }
        return id;
    }

    public boolean isOpen() {
        return this.data != null;
    }

    public void close() {
        if (this.data != null) {
            this.data.close();
            this.data = null;
        }
    }

    public String getProperty(String name) throws XMLDBException {
        this.check();
        try {
            return MetaData.class.getField(name).get(this.data.meta).toString();
        }
        catch (Exception ex) {
            Util.debug((Throwable)ex);
            return null;
        }
    }

    public void setProperty(String name, String val) throws XMLDBException {
        this.check();
        try {
            MetaData md = this.data.meta;
            Field f = MetaData.class.getField(name);
            Object k = f.get(md);
            if (k instanceof Boolean) {
                boolean b = val == null ? !((Boolean)k).booleanValue() : val.equalsIgnoreCase("true");
                f.setBoolean(md, b);
            } else if (k instanceof Integer) {
                f.setInt(md, Integer.parseInt(val));
            } else {
                f.set(md, val);
            }
        }
        catch (Exception ex) {
            Util.debug((Throwable)ex);
            throw new XMLDBException(1, "Property could not be set: " + name);
        }
    }

    private static boolean contains(String[] ids, String id) {
        for (String i : ids) {
            if (!i.equals(id)) continue;
            return true;
        }
        return false;
    }

    private void check() throws XMLDBException {
        if (this.data == null) {
            throw new XMLDBException(202);
        }
    }

    private static BXXMLResource checkXML(Resource resource) throws XMLDBException {
        if (!(resource instanceof BXXMLResource)) {
            throw new XMLDBException(300, "Unknown Resource: " + resource);
        }
        return (BXXMLResource)resource;
    }
}

