/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.function.BiConsumer;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.basex.core.Context;
import org.basex.core.StaticOptions;
import org.basex.core.jobs.JobException;
import org.basex.core.users.Algorithm;
import org.basex.core.users.Code;
import org.basex.core.users.User;
import org.basex.http.HTTPContext;
import org.basex.http.RequestContext;
import org.basex.io.serial.SerialMethod;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryInfo;
import org.basex.server.ClientInfo;
import org.basex.server.Log;
import org.basex.server.LoginException;
import org.basex.util.Base64;
import org.basex.util.Performance;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.http.Client;
import org.basex.util.http.MediaType;
import org.basex.util.http.Method;
import org.basex.util.http.RequestAttribute;
import org.basex.util.list.StringList;

public final class HTTPConnection
implements ClientInfo {
    private static final String[] FORWARDING_HEADERS = new String[]{"X-Forwarded-For", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"};
    public final HttpServletRequest request;
    public final HttpServletResponse response;
    public final Context context;
    public final RequestContext requestCtx;
    private final Performance perf = new Performance();
    private final StaticOptions.AuthMethod authMethod;
    private final String path;
    public String method;
    private SerializerOptions serializer;

    HTTPConnection(HttpServletRequest request, HttpServletResponse response, StaticOptions.AuthMethod authMethod) {
        this.request = request;
        this.response = response;
        this.context = new Context(HTTPContext.get().context(), (ClientInfo)this);
        this.method = request.getMethod();
        this.requestCtx = new RequestContext(request);
        response.setCharacterEncoding("UTF-8");
        this.path = HTTPConnection.normalize(request.getPathInfo());
        this.authMethod = authMethod != null ? authMethod : (StaticOptions.AuthMethod)this.context.soptions.get(StaticOptions.AUTHMETHOD);
    }

    void authenticate(String username) throws IOException {
        User user;
        String name;
        String string = name = this.method.equals(Method.OPTIONS.name()) ? "admin" : username;
        if (name == null) {
            name = this.context.soptions.get(StaticOptions.USER);
        }
        if ((user = this.context.users.get(name)) == null) {
            user = this.login();
        }
        this.context.user(user);
        StringBuilder uri = new StringBuilder(this.request.getRequestURI());
        String qs = this.request.getQueryString();
        if (qs != null) {
            uri.append('?').append(qs);
        }
        this.context.log.write(Log.LogType.REQUEST, "[" + this.method + "] " + uri, null, this.context);
    }

    public MediaType mediaType() {
        return HTTPConnection.mediaType(this.request);
    }

    public void initResponse() {
        SerializerOptions sopts = this.sopts();
        MediaType mt = HTTPConnection.mediaType(sopts);
        this.response.setContentType((mt.parameter("charset") == null ? new MediaType(mt + ";charset=" + sopts.get(SerializerOptions.ENCODING)) : mt).toString());
    }

    public String path() {
        return this.path;
    }

    public String dbpath() {
        int i = this.path.indexOf(47, 1);
        return i == -1 ? "" : this.path.substring(i + 1);
    }

    public String db() {
        int i = this.path.indexOf(47, 1);
        return this.path.substring(1, i == -1 ? this.path.length() : i);
    }

    public ArrayList<MediaType> accepts() {
        String accepts = this.request.getHeader("Accept");
        ArrayList<MediaType> list = new ArrayList<MediaType>();
        if (accepts == null) {
            list.add(MediaType.ALL_ALL);
        } else {
            for (String accept : accepts.split("\\s*,\\s*")) {
                double d;
                MediaType type = new MediaType(accept);
                String q = type.parameter("q");
                double d2 = d = q != null ? Token.toDouble((byte[])Token.token((String)q)) : 1.0;
                if (!(d > 0.0) || !(d <= 1.0)) continue;
                StringBuilder sb = new StringBuilder();
                String main = type.main();
                String sub = type.sub();
                sb.append(main.isEmpty() ? "*" : main).append('/');
                sb.append(sub.isEmpty() ? "*" : sub).append("; q=").append(d);
                list.add(new MediaType(sb.toString()));
            }
        }
        return list;
    }

    public void error(int code, String info) throws IOException {
        this.log(code, info);
        this.status(code, null, info);
    }

    public void sopts(SerializerOptions opts) {
        this.serializer = opts;
    }

    public SerializerOptions sopts() {
        if (this.serializer == null) {
            this.serializer = new SerializerOptions();
        }
        return this.serializer;
    }

    public void log(int status, String info) {
        this.context.log.write((Object)status, info, this.perf, this.context);
    }

    public String resolve(String location) {
        Object loc = location;
        if (Strings.startsWith((String)location, (char)'/')) {
            String uri = this.request.getRequestURI();
            String info = this.request.getPathInfo();
            loc = (info == null ? uri : uri.substring(0, uri.length() - info.length())) + location;
        }
        return loc;
    }

    public void redirect(String location) throws IOException {
        this.response.sendRedirect(this.resolve(location));
    }

    public void forward(String location) throws IOException, ServletException {
        this.request.getRequestDispatcher(this.resolve(location)).forward((ServletRequest)this.request, (ServletResponse)this.response);
    }

    public String clientAddress() {
        return this.getRemoteAddr() + ":" + this.request.getRemotePort();
    }

    public String clientName() {
        HttpSession session;
        Object value = this.request.getAttribute("id");
        if (value == null && (session = this.request.getSession(false)) != null) {
            boolean dba = (this.path() + "/").contains("/dba/");
            value = session.getAttribute(dba ? "dba" : "id");
        }
        return this.clientName(value, this.context);
    }

    void stop(JobException ex) throws IOException {
        int code = 460;
        String info = ex.getMessage();
        this.log(460, info);
        try {
            this.response.resetBuffer();
            this.response.setStatus(460);
            this.response.setContentType(MediaType.TEXT_PLAIN + "; charset=UTF-8");
            this.response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
            this.response.setHeader("Pragma", "no-cache");
            this.response.setHeader("Expires", "0");
            this.response.getOutputStream().write(Token.token((String)info));
        }
        catch (IllegalStateException e) {
            this.logError(460, null, info, e);
        }
    }

    public void status(int code, String message, String body) throws IOException {
        try {
            int c;
            this.response.resetBuffer();
            if (code == 401 && !this.response.containsHeader("WWW-Authenticate")) {
                TokenBuilder header = new TokenBuilder().add((Object)this.authMethod);
                header.add(32).add((Object)RequestAttribute.REALM).add("=\"").add("BaseX").add(34);
                if (this.authMethod == StaticOptions.AuthMethod.DIGEST) {
                    String nonce = Strings.md5((String)Long.toString(System.nanoTime()));
                    header.add(",").add((Object)RequestAttribute.QOP).add("=\"").add("auth").add(44).add("auth-int");
                    header.add(34).add(44).add((Object)RequestAttribute.NONCE).add("=\"").add(nonce).add(34);
                }
                this.response.setHeader("WWW-Authenticate", header.toString());
            }
            int n = c = code < 0 || code > 999 ? 500 : code;
            if (message == null) {
                this.response.setStatus(c);
            } else {
                this.response.setStatus(c, message.replaceAll("[^\\x20-\\x7F]", "?"));
            }
            if (body != null) {
                this.response.setContentType(MediaType.TEXT_PLAIN + "; charset=UTF-8");
                this.response.getOutputStream().write(new TokenBuilder(Token.token((String)body)).normalize().finish());
            }
        }
        catch (IllegalArgumentException | IllegalStateException ex) {
            this.logError(code, message, body, ex);
        }
    }

    public void timing(QueryInfo qi) {
        StringList list = new StringList(4L);
        BiConsumer<String, Long> add = (name, nano) -> list.add((Object)(name + ";dur=" + Performance.getTime((long)nano, (int)1)));
        add.accept("parse", qi.parsing.get());
        add.accept("compile", qi.compiling.get());
        add.accept("optimize", qi.optimizing.get());
        add.accept("evaluate", qi.evaluating.get());
        add.accept("serialize", qi.serializing.get());
        this.response.setHeader("Server-Timing", String.join((CharSequence)",", (CharSequence[])list.finish()));
    }

    public static MediaType mediaType(SerializerOptions sopts) {
        String type = sopts.get(SerializerOptions.MEDIA_TYPE);
        if (!type.isEmpty()) {
            return new MediaType(type);
        }
        SerialMethod sm = (SerialMethod)sopts.get(SerializerOptions.METHOD);
        if (sm == SerialMethod.BASEX || sm == SerialMethod.ADAPTIVE || sm == SerialMethod.XML) {
            return MediaType.APPLICATION_XML;
        }
        if (sm == SerialMethod.XHTML || sm == SerialMethod.HTML) {
            return MediaType.TEXT_HTML;
        }
        if (sm == SerialMethod.JSON) {
            return MediaType.APPLICATION_JSON;
        }
        return MediaType.TEXT_PLAIN;
    }

    public static MediaType mediaType(HttpServletRequest request) {
        String ct = request.getContentType();
        return ct == null ? MediaType.ALL_ALL : new MediaType(ct);
    }

    public static String remoteAddress(HttpServletRequest request) {
        for (String header : FORWARDING_HEADERS) {
            String addr = request.getHeader(header);
            if (addr == null || addr.isEmpty() || "unknown".equalsIgnoreCase(addr)) continue;
            return addr;
        }
        return request.getRemoteAddr();
    }

    private static String normalize(String path) {
        TokenBuilder tmp = new TokenBuilder();
        if (path != null) {
            TokenBuilder tb = new TokenBuilder();
            int pl = path.length();
            for (int p = 0; p < pl; ++p) {
                char ch = path.charAt(p);
                if (ch == '/') {
                    if (tb.isEmpty()) continue;
                    tmp.add(47).add(tb.toArray());
                    tb.reset();
                    continue;
                }
                tb.add((int)ch);
            }
            if (!tb.isEmpty()) {
                tmp.add(47).add(tb.finish());
            }
        }
        if (tmp.isEmpty()) {
            tmp.add(47);
        }
        return tmp.toString();
    }

    private User login() throws IOException {
        try {
            User user;
            if (this.authMethod == StaticOptions.AuthMethod.CUSTOM) {
                user = this.user("admin");
            } else {
                String[] stringArray;
                String header = this.request.getHeader("Authorization");
                if (header != null) {
                    stringArray = Strings.split((String)header, (char)' ', (int)2);
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = "";
                }
                String[] am = stringArray;
                StaticOptions.AuthMethod meth = (StaticOptions.AuthMethod)StaticOptions.AUTHMETHOD.get(am[0]);
                if (this.authMethod != meth) {
                    throw new LoginException("% authentication expected.", new Object[]{this.authMethod});
                }
                if (this.authMethod == StaticOptions.AuthMethod.BASIC) {
                    String details = am.length > 1 ? am[1] : "";
                    String[] creds = Strings.split((String)Base64.decode((String)details), (char)':', (int)2);
                    user = this.user(creds[0]);
                    if (creds.length < 2 || !user.matches(creds[1])) {
                        throw new LoginException(user.name());
                    }
                } else {
                    EnumMap auth = Client.authHeaders((String)header);
                    user = this.user((String)auth.get(RequestAttribute.USERNAME));
                    String nonce = (String)auth.get(RequestAttribute.NONCE);
                    String cnonce = (String)auth.get(RequestAttribute.CNONCE);
                    String ha1 = user.code(Algorithm.DIGEST, Code.HASH);
                    if (Strings.eq((String)((String)auth.get(RequestAttribute.ALGORITHM)), (String)"MD5-sess")) {
                        ha1 = Strings.md5((String)(ha1 + ":" + nonce + ":" + cnonce));
                    }
                    StringBuilder h2 = new StringBuilder().append(this.method).append(':').append((String)auth.get(RequestAttribute.URI));
                    String qop = (String)auth.get(RequestAttribute.QOP);
                    if (Strings.eq((String)qop, (String)"auth-int")) {
                        h2.append(':').append(Strings.md5((String)this.requestCtx.body().toString()));
                    }
                    String ha2 = Strings.md5((String)h2.toString());
                    StringBuilder sb = new StringBuilder(ha1).append(':').append(nonce);
                    if (Strings.eq((String)qop, (String[])new String[]{"auth", "auth-int"})) {
                        sb.append(':').append((String)auth.get(RequestAttribute.NC));
                        sb.append(':').append(cnonce).append(':').append(qop);
                    }
                    sb.append(':').append(ha2);
                    if (!Strings.md5((String)sb.toString()).equals(auth.get(RequestAttribute.RESPONSE))) {
                        throw new LoginException(user.name());
                    }
                }
            }
            this.context.blocker.remove(Token.token((String)this.getRemoteAddr()));
            return user;
        }
        catch (LoginException ex) {
            this.context.blocker.delay(Token.token((String)this.getRemoteAddr()));
            throw ex;
        }
    }

    private User user(String name) throws LoginException {
        User user = this.context.users.get(name);
        if (user == null || !user.enabled()) {
            throw new LoginException(name);
        }
        return user;
    }

    private String getRemoteAddr() {
        return HTTPConnection.remoteAddress(this.request);
    }

    private void logError(int code, String message, String info, Exception ex) {
        StringBuilder sb = new StringBuilder();
        sb.append("Code: ").append(code);
        if (info != null) {
            sb.append(", Info: ").append(info);
        }
        if (message != null) {
            sb.append(", Message: ").append(message);
        }
        sb.append(", Error: ").append(Util.message((Throwable)ex));
        this.log(500, sb.toString());
    }
}

