/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.rest;

import java.io.IOException;
import java.util.Map;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.StaticOptions;
import org.basex.core.Text;
import org.basex.core.cmd.XQuery;
import org.basex.core.parse.CommandParser;
import org.basex.http.HTTPStatus;
import org.basex.http.rest.RESTQuery;
import org.basex.http.rest.RESTSession;
import org.basex.io.IOFile;
import org.basex.query.QueryException;
import org.basex.util.Util;

final class RESTRun
extends RESTQuery {
    private RESTRun(RESTSession session, Map<String, String[]> bindings) {
        super(session, bindings);
    }

    static RESTRun get(RESTSession session, String path, Map<String, String[]> bindings) throws IOException {
        String rpath;
        Context context = session.conn.context;
        String webpath = context.soptions.get(StaticOptions.WEBPATH);
        IOFile root = new IOFile(webpath).resolve(rpath = context.soptions.get(StaticOptions.RESTPATH));
        IOFile file = new IOFile(root, path);
        if (!file.exists() || file.isDir() || !file.path().startsWith(root.path())) {
            throw HTTPStatus.NOT_FOUND_X.get(Util.info((Object)Text.RES_NOT_FOUND_X, (Object[])new Object[]{path}));
        }
        String input = file.string();
        if (file.hasSuffix(new String[]{".bxs"})) {
            try {
                for (Command cmd : CommandParser.get((String)input, (Context)context).parse()) {
                    session.add(cmd.baseURI(file.path()));
                }
            }
            catch (QueryException ex) {
                throw new IOException(ex);
            }
        } else {
            session.add(new XQuery(input).baseURI(file.path()));
        }
        return new RESTRun(session, bindings);
    }
}

