/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.restxq;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.basex.http.HTTPConnection;
import org.basex.http.restxq.RestXqFunction;
import org.basex.http.web.WebModule;
import org.basex.http.web.WebParam;
import org.basex.http.web.WebText;
import org.basex.query.QueryException;
import org.basex.query.func.inspect.Inspect;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FBuilder;
import org.basex.query.value.node.FElem;
import org.basex.query.value.node.FNode;
import org.basex.query.var.Var;
import org.basex.util.Token;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.list.TokenList;

public final class RestXqWadl {
    private static final QNm Q_APPLICATION = RestXqWadl.qnm("application");
    private static final QNm Q_RESOURCES = RestXqWadl.qnm("resources");
    private static final QNm Q_RESOURCE = RestXqWadl.qnm("resource");
    private static final QNm Q_DOC = RestXqWadl.qnm("doc");
    private static final QNm Q_METHOD = RestXqWadl.qnm("method");
    private static final QNm Q_REQUEST = RestXqWadl.qnm("request");
    private static final QNm Q_RESPONSE = RestXqWadl.qnm("response");
    private static final QNm Q_REPRESENTATION = RestXqWadl.qnm("representation");
    private static final QNm Q_PARAM = RestXqWadl.qnm("param");
    private final HttpServletRequest request;

    public RestXqWadl(HttpServletRequest request) {
        this.request = request;
    }

    public synchronized FNode create(HashMap<String, WebModule> modules) throws QueryException {
        FBuilder application = FElem.build((QNm)Q_APPLICATION).declareNS();
        String base = this.request.getRequestURL().toString().replace(this.request.getRequestURI(), this.request.getContextPath());
        FBuilder resources = FElem.build((QNm)Q_RESOURCES).add(WebText.Q_BASE, (Object)base);
        TreeMap<CallSite, FBuilder> map = new TreeMap<CallSite, FBuilder>();
        for (WebModule module : modules.values()) {
            for (RestXqFunction func : module.functions()) {
                TokenList descs;
                if (func.path == null) continue;
                TokenObjMap xqdoc = func.function.doc();
                String path = func.path.toString();
                String methods = func.methods.toString().replaceAll("[^A-Z ]", "");
                FBuilder resource = FElem.build((QNm)Q_RESOURCE).add(WebText.Q_PATH, (Object)path);
                map.put((CallSite)((Object)(path.replaceAll("^/*", "/") + " " + methods)), resource);
                Matcher var = Pattern.compile("\\$[^}]*").matcher(path);
                while (var.find()) {
                    RestXqWadl.addParam(var.group().substring(1), "template", resource, (TokenObjMap<TokenList>)xqdoc, func);
                }
                FBuilder method = FElem.build((QNm)Q_METHOD).add(WebText.Q_NAME, (Object)methods);
                TokenList tokenList = descs = xqdoc != null ? (TokenList)xqdoc.get(Inspect.DOC_DESCRIPTION) : null;
                if (descs != null) {
                    Iterator iterator = descs.iterator();
                    while (iterator.hasNext()) {
                        Iterator<WebParam> desc = (Iterator<WebParam>)((byte[])iterator.next());
                        RestXqWadl.addDoc((byte[])desc, method);
                    }
                }
                FBuilder rqst = FElem.build((QNm)Q_REQUEST);
                for (WebParam wp : func.queryParams) {
                    RestXqWadl.addParam(wp.name, "query", rqst, (TokenObjMap<TokenList>)xqdoc, func);
                }
                for (WebParam wp : func.formParams) {
                    RestXqWadl.addParam(wp.name, "query", rqst, (TokenObjMap<TokenList>)xqdoc, func);
                }
                for (WebParam wp : func.headerParams) {
                    RestXqWadl.addParam(wp.name, "header", rqst, (TokenObjMap<TokenList>)xqdoc, func);
                }
                method.add(rqst);
                FBuilder response = FElem.build((QNm)Q_RESPONSE);
                FBuilder representation = FElem.build((QNm)Q_REPRESENTATION);
                representation.add(WebText.Q_MEDIA_TYPE, (Object)HTTPConnection.mediaType(func.sopts));
                response.add(representation);
                method.add(response);
                resource.add(method);
            }
        }
        for (FBuilder elem : map.values()) {
            resources.add(elem);
        }
        return application.add(resources).finish();
    }

    private static void addParam(String name, String style, FBuilder root, TokenObjMap<TokenList> xqdoc, RestXqFunction func) throws QueryException {
        FBuilder param = FElem.build((QNm)Q_PARAM).add(WebText.Q_NAME, (Object)name).add(WebText.Q_STYLE, (Object)style);
        QNm qnm = new QNm(name);
        for (Var var : func.function.params) {
            if (!var.name.eq(qnm) || var.declType == null) continue;
            param.add(WebText.Q_TYPE, (Object)var.declType);
        }
        RestXqWadl.addDoc(Inspect.doc(xqdoc, (byte[])Token.token((String)name)), param);
        root.add(param);
    }

    private static void addDoc(byte[] xqdoc, FBuilder parent) throws QueryException {
        if (xqdoc == null) {
            return;
        }
        FBuilder doc = FElem.build((QNm)Q_DOC).addNS(Token.EMPTY, Token.token((String)"http://www.w3.org/1999/xhtml"));
        Inspect.add((byte[])xqdoc, (FBuilder)doc);
        parent.add(doc);
    }

    private static QNm qnm(String name) {
        return new QNm(WebText.WADL_PREFIX, name, WebText.WADL_URI);
    }
}

