/*
 * Decompiled with CFR 0.152.
 */
package org.basinmc.lavatory;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.basinmc.lavatory.version.VersionReference;

public final class Manifest {
    public static final String MANIFEST_URL = "https://launchermeta.mojang.com/mc/game/version_manifest.json";
    private final VersionReference latestStable;
    private final VersionReference latestSnapshot;
    private final Map<String, VersionReference> versionMap;

    public Manifest(@NonNull VersionReference latestStable, @NonNull VersionReference latestSnapshot, @NonNull Map<String, VersionReference> versionMap) {
        this.latestStable = latestStable;
        this.latestSnapshot = latestSnapshot;
        this.versionMap = new HashMap<String, VersionReference>(versionMap);
    }

    @JsonCreator
    protected Manifest(@JsonProperty(value="latest", required=true) @NonNull Map<String, String> latestVersions, @JsonProperty(value="versions", required=true) @NonNull Set<VersionReference> references) {
        this.versionMap = references.stream().collect(Collectors.toMap(VersionReference::getId, r -> r));
        String latestVersion = latestVersions.get("release");
        if (latestVersion == null) {
            throw new IllegalArgumentException("Illegal version table: No latest stable release version given");
        }
        this.latestStable = this.versionMap.get(latestVersion);
        if (this.latestStable == null) {
            throw new IllegalArgumentException("Illegal version table: Invalid latest stable release version given (\"" + latestVersion + "\")");
        }
        latestVersion = latestVersions.get("snapshot");
        if (latestVersion == null) {
            throw new IllegalArgumentException("Illegal version table: No latest snapshot release version given");
        }
        this.latestSnapshot = this.versionMap.get(latestVersion);
        if (this.latestSnapshot == null) {
            throw new IllegalArgumentException("Illegal version table: Invalid latest snapshot release version given (\"" + latestVersion + "\")");
        }
    }

    @NonNull
    public static Manifest fetch() throws IOException {
        try (InputStream inputStream = new URL(MANIFEST_URL).openStream();){
            Manifest manifest = Manifest.read(inputStream);
            return manifest;
        }
    }

    @NonNull
    public VersionReference getLatestStable() {
        return this.latestStable;
    }

    @NonNull
    public VersionReference getLatestSnapshot() {
        return this.latestSnapshot;
    }

    @NonNull
    public Optional<VersionReference> getVersion(@NonNull String versionId) {
        return Optional.ofNullable(this.versionMap.get(versionId));
    }

    @NonNull
    public Set<VersionReference> getVersions() {
        return Collections.unmodifiableSet(new HashSet<VersionReference>(this.versionMap.values()));
    }

    @NonNull
    public static Manifest read(@NonNull InputStream inputStream) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.findAndRegisterModules();
        return (Manifest)mapper.readValue(inputStream, Manifest.class);
    }

    @NonNull
    public static Manifest read(@NonNull Path path) throws IOException {
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            Manifest manifest = Manifest.read(inputStream);
            return manifest;
        }
    }

    @NonNull
    public static Manifest read(@NonNull Reader reader) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.findAndRegisterModules();
        return (Manifest)mapper.readValue(reader, Manifest.class);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Manifest that = (Manifest)o;
        return Objects.equals(this.latestStable, that.latestStable) && Objects.equals(this.latestSnapshot, that.latestSnapshot) && Objects.equals(this.versionMap, that.versionMap);
    }

    public int hashCode() {
        return Objects.hash(this.latestStable, this.latestSnapshot, this.versionMap);
    }
}

