/*
 * Decompiled with CFR 0.152.
 */
package org.basinmc.lavatory.asset;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.basinmc.lavatory.asset.AssetObject;

public class AssetIndex {
    private final Map<String, AssetObject> objects;

    @JsonCreator
    public AssetIndex(@JsonProperty(value="objects", required=true) @NonNull Map<String, AssetObject> objects) {
        this.objects = new HashMap<String, AssetObject>(objects);
    }

    @NonNull
    public Optional<AssetObject> getObject(@NonNull String path) {
        return Optional.ofNullable(this.objects.get(path));
    }

    @NonNull
    public Map<String, AssetObject> getObjects() {
        return Collections.unmodifiableMap(this.objects);
    }

    @NonNull
    public static AssetIndex read(@NonNull InputStream inputStream) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (AssetIndex)mapper.readValue(inputStream, AssetIndex.class);
    }

    @NonNull
    public static AssetIndex read(@NonNull Path path) throws IOException {
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            AssetIndex assetIndex = AssetIndex.read(inputStream);
            return assetIndex;
        }
    }

    @NonNull
    public static AssetIndex read(@NonNull Reader reader) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (AssetIndex)mapper.readValue(reader, AssetIndex.class);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssetIndex that = (AssetIndex)o;
        return Objects.equals(this.objects, that.objects);
    }

    public int hashCode() {
        return Objects.hash(this.objects);
    }
}

