/*
 * Decompiled with CFR 0.152.
 */
package org.basinmc.lavatory.file;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Objects;

public class Download {
    public static final String CHECKSUM_ALGORITHM = "SHA-1";
    private final String sha1;
    private final long size;
    private final URL url;

    @JsonCreator
    public Download(@JsonProperty(value="sha1", required=true) @NonNull String sha1, @JsonProperty(value="size", required=true) long size, @JsonProperty(value="url", required=true) @NonNull URL url) {
        this.sha1 = sha1;
        this.size = size;
        this.url = url;
    }

    public void fetch(@NonNull Path target) throws IOException {
        try (FileChannel channel = FileChannel.open(target, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
             InputStream inputStream = this.url.openStream();
             ReadableByteChannel inputChannel = Channels.newChannel(inputStream);){
            channel.transferFrom(inputChannel, 0L, Long.MAX_VALUE);
        }
    }

    @NonNull
    public String getSha1() {
        return this.sha1;
    }

    public byte[] getSha1Bytes() {
        if (this.sha1.length() % 2 != 0) {
            throw new IllegalStateException("Illegal hash: Odd number of characters");
        }
        byte[] bytes = new byte[this.sha1.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            String element = this.sha1.substring(i * 2, i * 2 + 2);
            bytes[i] = (byte)(Short.parseShort(element, 16) & 0xFF);
        }
        return bytes;
    }

    public long getSize() {
        return this.size;
    }

    @NonNull
    public URL getUrl() {
        return this.url;
    }

    public boolean verify(@NonNull Path path) throws IOException {
        MessageDigest digest;
        if (Files.size(path) != this.size) {
            return false;
        }
        try {
            digest = MessageDigest.getInstance(CHECKSUM_ALGORITHM);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new UnsupportedOperationException("JVM does not support SHA-1 digest algorithm");
        }
        try (FileChannel channel = FileChannel.open(path, StandardOpenOption.READ);){
            ByteBuffer heap = ByteBuffer.allocate(512);
            while (channel.read(heap) > 0) {
                heap.flip();
                digest.update(heap);
                heap.clear();
            }
            byte[] checksum = digest.digest();
            boolean bl = Arrays.equals(this.getSha1Bytes(), checksum);
            return bl;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Download)) {
            return false;
        }
        Download download = (Download)o;
        return this.size == download.size && Objects.equals(this.sha1, download.sha1) && Objects.equals(this.url, download.url);
    }

    public int hashCode() {
        return Objects.hash(this.sha1, this.size, this.url);
    }
}

