/*
 * Decompiled with CFR 0.152.
 */
package org.basinmc.lavatory.rule;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.basinmc.lavatory.ResolverContext;
import org.basinmc.lavatory.rule.Rule;
import org.basinmc.lavatory.rule.RuleControlledResource;

public abstract class AbstractRuleControlledResource
implements RuleControlledResource {
    private final Set<Rule> rules;

    public AbstractRuleControlledResource(@Nullable Set<Rule> rules) {
        this.rules = rules == null ? Collections.emptySet() : new HashSet<Rule>(rules);
    }

    @Override
    @NonNull
    public Set<Rule> getRules() {
        return Collections.unmodifiableSet(this.rules);
    }

    @Override
    public boolean evaluate(@NonNull ResolverContext ctx) {
        return this.rules.stream().allMatch(r -> r.evaluate(ctx) == Rule.Action.ALLOW);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractRuleControlledResource)) {
            return false;
        }
        AbstractRuleControlledResource that = (AbstractRuleControlledResource)o;
        return Objects.equals(this.rules, that.rules);
    }

    public int hashCode() {
        return Objects.hash(this.rules);
    }
}

