/*
 * Decompiled with CFR 0.152.
 */
package org.basinmc.lavatory.rule.feature;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public enum Feature {
    CUSTOM_RESOLUTION("has_custom_resolution"),
    DEMO_USER("is_demo_user");

    private static final Map<String, Feature> keyMap;
    private final String key;

    private Feature(String key) {
        this.key = key;
    }

    @NonNull
    public static Optional<Feature> byKey(@NonNull String key) {
        return Optional.ofNullable(keyMap.get(key));
    }

    @NonNull
    public String getKey() {
        return this.key;
    }

    static {
        keyMap = new HashMap<String, Feature>();
        for (Feature feature : Feature.values()) {
            keyMap.put(feature.key, feature);
        }
    }
}

