/*
 * Decompiled with CFR 0.152.
 */
package org.basinmc.lavatory.rule.system;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.basinmc.lavatory.ResolverContext;
import org.basinmc.lavatory.rule.RuleCondition;
import org.basinmc.lavatory.rule.system.OperatingSystem;

public class OperatingSystemCondition
implements RuleCondition {
    private final OperatingSystem system;
    private final Pattern version;

    @JsonCreator
    public OperatingSystemCondition(@JsonProperty(value="name") @Nullable String system, @JsonProperty(value="version") @Nullable Pattern version) {
        this.system = system == null ? null : OperatingSystem.byKey(system).orElseThrow(() -> new IllegalArgumentException("Illegal operating system: \"" + system + "\""));
        this.version = version;
        if (system == null && version == null) {
            throw new IllegalArgumentException("Illegal operating system condition: Must specify either system or version");
        }
    }

    @Override
    public boolean evaluate(@NonNull ResolverContext ctx) {
        if (this.system != null && this.system != ctx.getOperatingSystem()) {
            return false;
        }
        return this.version == null || this.version.matcher(ctx.getOperatingSystemVersion()).matches();
    }

    @NonNull
    public Optional<OperatingSystem> getSystem() {
        return Optional.ofNullable(this.system);
    }

    @NonNull
    public Optional<Pattern> getVersion() {
        return Optional.ofNullable(this.version);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperatingSystemCondition that = (OperatingSystemCondition)o;
        return this.system == that.system && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.system, this.version});
    }
}

